/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.format.TextBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

public class XmlBuilder
extends TextBuilder {
    Deque<String> eltstack = new ArrayDeque<String>();

    public XmlBuilder() {
    }

    public XmlBuilder(int n2) {
        super(n2);
    }

    public XmlBuilder(int n2, int n3) {
        super(n2, n3);
    }

    public void appendStandardHeader() {
        this.appendHeader(1, 0, "UTF-8", false);
    }

    public void appendHeader(int n2, int n3, String string, boolean bl) {
        String string2 = !bl ? "" : "standalone=\"true\"";
        this.appendLine("<?xml version=\"%d.%d\" encoding=\"%s\" %s?>", n2, n3, string, string2);
    }

    public void openElement(String string) {
        this.openElement(string, null, false);
    }

    public void openElement(String string, Map<String, String> map) {
        this.openElement(string, map, false);
    }

    public void openElement(String string, Map<String, String> map, boolean bl) {
        this.append("<%s", string);
        if (map != null) {
            for (String string2 : map.keySet()) {
                this.append(" %s=\"%s\"", string2, map.get(string2));
            }
        }
        if (bl) {
            this.append(" />");
        } else {
            this.eltstack.push(string);
            this.append(">");
            this.indent();
        }
    }

    public void closeElement() {
        this.closeElement(false);
    }

    public void closeElement(boolean bl) {
        this.unindent();
        String string = this.eltstack.pop();
        this.append("</%s>", string);
        if (bl) {
            this.appendLine();
        }
    }

    public static CharSequence escapeTextData(CharSequence charSequence) {
        return XmlBuilder.escape(charSequence, MODE.TEXT);
    }

    public static CharSequence escapeAttributeData(CharSequence charSequence) {
        return XmlBuilder.escape(charSequence, MODE.ATTRIBUTE);
    }

    public static CharSequence escapeAll(CharSequence charSequence) {
        return XmlBuilder.escape(charSequence, MODE.ALL);
    }

    private static CharSequence escape(CharSequence charSequence, MODE mODE) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            if (c2 == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c2 == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c2 == '>' && mODE != MODE.ATTRIBUTE) {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c2 == '\"' && mODE != MODE.TEXT) {
                stringBuilder.append("&quot;");
                continue;
            }
            if (c2 == '\'' && mODE != MODE.TEXT) {
                stringBuilder.append("&apos;");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder;
    }

    private static enum MODE {
        ALL,
        TEXT,
        ATTRIBUTE;

    }
}

