/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.base.SystemUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.reflect.Field;

public class XercesUpdater {
    private static final ILogger logger = GlobalLog.getLogger(XercesUpdater.class);
    private static final int majorJavaVersion = SystemUtil.getMajorJavaVersion();
    private ClassLoader cl;
    private int modcnt;
    private byte[] array;

    public XercesUpdater() {
        this(ClassLoader.getSystemClassLoader());
    }

    public XercesUpdater(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        this.cl = classLoader;
    }

    public int getModificationCount() {
        return this.modcnt;
    }

    public int update() {
        return this.updateXML10();
    }

    private int updateXML10() {
        E[] eArray = new E[]{new E(0, "com.sun.org.apache.xerces.internal.util.XMLChar", "CHARS"), new E(0, "com.sun.org.apache.xml.internal.utils.XMLChar", "CHARS"), new E(0, "org.apache.xerces.util.XMLChar", "CHARS"), new E(0, "com.sun.xml.internal.fastinfoset.org.apache.xerces.util.XMLChar", "CHARS")};
        int n2 = 0;
        for (E e : eArray) {
            if (!this.updateXML10(e)) continue;
            ++n2;
        }
        return n2;
    }

    private boolean updateXML10(E e) {
        if (e.maxJavaVer != 0 && e.maxJavaVer < majorJavaVersion) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(e.cname, true, this.cl);
            Field field = clazz.getDeclaredField(e.fname);
            field.setAccessible(true);
            try {
                this.array = (byte[])field.get(null);
                if (this.array.length == 65536) {
                    this.setNameStart(192, 214);
                    this.setNameStart(216, 246);
                    this.setNameStart(248, 767);
                    this.setNameStart(880, 893);
                    this.setNameStart(895, 8191);
                    this.setNameStart(8204, 8205);
                    this.setNameStart(8304, 8591);
                    this.setNameStart(11264, 12271);
                    this.setNameStart(12289, 55295);
                    this.setNameStart(63744, 64975);
                    this.setNameStart(65008, 65533);
                    this.setName(768, 879);
                    this.setName(8255, 8256);
                }
            }
            finally {
                field.setAccessible(false);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void setNameStart(int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            if ((this.array[i] & 0xF) == 13) continue;
            this.array[i] = (byte)(this.array[i] & 0xF0 | 0xD);
            ++this.modcnt;
        }
    }

    private void setName(int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            if ((this.array[i] & 0xF) == 9) continue;
            this.array[i] = (byte)(this.array[i] & 0xF0 | 9);
            ++this.modcnt;
        }
    }

    static class E {
        int maxJavaVer;
        String cname;
        String fname;

        public E(int n2, String string, String string2) {
            this.maxJavaVer = n2;
            this.cname = string;
            this.fname = string2;
        }
    }
}

