/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TokenExtractor {
    public static final IDelimiterFinder DF_WhiteSpace = c2 -> Character.isSpaceChar(c2);
    public static final IDelimiterFinder DF_CommonFullSymbolChars = c2 -> !Character.isJavaIdentifierPart(c2) && c2 != '/' && c2 != '+';
    public static final IDelimiterFinder DF_CommonSymbolChars = c2 -> !Character.isJavaIdentifierPart(c2);
    public static final IDelimiterFinder DF_NonAlphaNum = c2 -> !Character.isAlphabetic(c2) && !Character.isDigit(c2);
    public static final IDelimiterFinder DF_Assignment = c2 -> c2 == '=';
    private static final List<TokenExtractor> tokenList = Collections.unmodifiableList(Arrays.asList(new TokenExtractor(DF_WhiteSpace), new TokenExtractor(DF_CommonFullSymbolChars), new TokenExtractor(DF_CommonSymbolChars), new TokenExtractor(DF_NonAlphaNum), new TokenExtractor(DF_Assignment)));
    private final IDelimiterFinder delimiterFinder;

    public static List<TokenExtractor> getGenericTokenList() {
        return tokenList;
    }

    public TokenExtractor(IDelimiterFinder iDelimiterFinder) {
        if (iDelimiterFinder == null) {
            throw new NullPointerException();
        }
        this.delimiterFinder = iDelimiterFinder;
    }

    public String extract(String string, int n2) {
        int[] nArray = this.extractCoordinates(string, n2);
        if (nArray == null) {
            return null;
        }
        return string.substring(nArray[0], nArray[1]);
    }

    public int[] extractCoordinates(String string, int n2) {
        int n3;
        int n4 = string.length();
        int n5 = 0;
        for (n3 = n2; n3 < string.length(); ++n3) {
            if (!this.match(string, n3)) continue;
            n4 = n3;
            break;
        }
        if (n4 == n2) {
            return null;
        }
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            if (!this.match(string, n3)) continue;
            n5 = n3 + 1;
            break;
        }
        if (n5 >= n4) {
            return null;
        }
        return new int[]{n5, n4};
    }

    protected boolean match(String string, int n2) {
        char c2 = string.charAt(n2);
        return this.delimiterFinder.isDelimiter(c2);
    }

    @FunctionalInterface
    public static interface IDelimiterFinder {
        public boolean isDelimiter(char var1);
    }
}

