/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.format.Strings;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeFormatter {
    public static String formatTimestamp(long l2) {
        return TimeFormatter.formatTimestamp(l2, "UTC");
    }

    public static String formatTimestamp(long l2, String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        calendar.setTimeZone(TimeZone.getTimeZone(string));
        return Strings.ff("%04d/%02d/%02d-%02d:%02d:%02d", calendar.get(1), 1 + calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static String formatTimestampLocal(long l2) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        String string = dateFormat.format(new Date(l2));
        String string2 = dateFormat.getTimeZone().getDisplayName(false, 0);
        return string + " " + string2;
    }

    public static String formatTimestampDelta(long l2) {
        long l3;
        long l4;
        Object object = "";
        if (l2 < 0L) {
            object = "-";
            l2 = -l2;
        }
        if ((l4 = l2 / 1000L) >= 86400L) {
            l3 = l4 / 86400L;
            l4 %= 86400L;
            object = (String)object + Strings.ff("%dd ", l3);
        }
        if (l4 >= 3600L) {
            l3 = l4 / 3600L;
            l4 %= 3600L;
            object = (String)object + Strings.ff("%dh ", l3);
        }
        if (l4 >= 60L) {
            l3 = l4 / 60L;
            l4 %= 60L;
            object = (String)object + Strings.ff("%dm ", l3);
        }
        if (l4 != 0L || ((String)object).isEmpty() || ((String)object).equals("-")) {
            object = (String)object + Strings.ff("%ds", l4);
        }
        return ((String)object).trim();
    }
}

