/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.format.Strings;

public class TextBuilder
implements Appendable {
    private StringBuilder sb;
    private int indentationLevel;
    private int indentationSize;

    public TextBuilder() {
        this(4);
    }

    public TextBuilder(int n2) {
        this(n2, 16);
    }

    public TextBuilder(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.indentationSize = n2;
        this.sb = new StringBuilder(n3);
    }

    public int length() {
        return this.sb.length();
    }

    public void clear() {
        this.sb.setLength(0);
    }

    public void updateIndentation(boolean bl) {
        if (bl) {
            this.indent();
        } else {
            this.unindent();
        }
    }

    public TextBuilder indent(boolean bl) {
        ++this.indentationLevel;
        if (bl) {
            this.eol();
        }
        return this;
    }

    public TextBuilder indent() {
        return this.indent(false);
    }

    public TextBuilder unindent() {
        if (this.indentationLevel == 0) {
            throw new IllegalStateException("Negative indentation level");
        }
        --this.indentationLevel;
        return this;
    }

    @Override
    public TextBuilder append(CharSequence charSequence) {
        return this.append((Object)charSequence);
    }

    @Override
    public TextBuilder append(CharSequence charSequence, int n2, int n3) {
        return this.append((Object)charSequence.subSequence(n2, n3));
    }

    @Override
    public TextBuilder append(char c2) {
        return this.appendInternal(false, false, Character.toString(c2), new Object[0]);
    }

    public TextBuilder append(byte by) {
        return this.appendInternal(false, false, Byte.toString(by), new Object[0]);
    }

    public TextBuilder append(short s2) {
        return this.appendInternal(false, false, Short.toString(s2), new Object[0]);
    }

    public TextBuilder append(int n2) {
        return this.appendInternal(false, false, Integer.toString(n2), new Object[0]);
    }

    public TextBuilder append(long l2) {
        return this.appendInternal(false, false, Long.toString(l2), new Object[0]);
    }

    public TextBuilder append(float f) {
        return this.appendInternal(false, false, Float.toString(f), new Object[0]);
    }

    public TextBuilder append(double d) {
        return this.appendInternal(false, false, Double.toString(d), new Object[0]);
    }

    public TextBuilder append(Object object) {
        return this.appendInternal(false, false, object == null ? "null" : object.toString(), new Object[0]);
    }

    public TextBuilder append(String string, Object ... objectArray) {
        return this.appendInternal(false, false, string, objectArray);
    }

    public TextBuilder appendLine(String string, Object ... objectArray) {
        return this.appendInternal(false, true, string, objectArray);
    }

    public TextBuilder appendLine(boolean bl) {
        return this.appendInternal(bl, true, "", new Object[0]);
    }

    public TextBuilder appendLine() {
        return this.appendLine(false);
    }

    public TextBuilder eol() {
        return this.appendLine();
    }

    public TextBuilder space() {
        return this.append(' ');
    }

    private TextBuilder appendInternal(boolean bl, boolean bl2, String string, Object ... objectArray) {
        if (!(bl || this.sb.length() != 0 && this.sb.charAt(this.sb.length() - 1) != '\n')) {
            this.sb.append(Strings.generate(' ', this.indentationSize * this.indentationLevel));
        }
        this.sb.append(objectArray.length == 0 ? string : Strings.ff((Appendable)null, string, objectArray));
        if (bl2) {
            this.sb.append(Strings.LINESEP);
        }
        return this;
    }

    public void removeChar(int n2) {
        this.sb.deleteCharAt(n2);
    }

    public void removeChars(int n2, int n3) {
        this.sb.delete(n2, n3);
    }

    public void removeLastChar() {
        this.sb.deleteCharAt(this.sb.length() - 1);
    }

    public void removeLastLine() {
        int n2 = this.sb.lastIndexOf(Strings.LINESEP);
        if (n2 == -1) {
            n2 = 0;
        }
        this.sb.setLength(n2);
    }

    String formatLastLine() {
        int n2 = this.sb.lastIndexOf(Strings.LINESEP);
        return n2 == -1 ? this.sb.toString() : this.sb.substring(n2 + Strings.LINESEP.length());
    }

    public String toString() {
        return this.sb.toString();
    }
}

