/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.base.StarMatcher;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.AlphanumCharComparator;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.NumberComparator;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.primitives.Characters;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    public static final String LINESEP;
    static Charset csASCII;
    static Charset csUTF8;
    static Charset csUTF16;
    static Charset csUTF16LE;
    static Charset csUTF16BE;
    static Charset csUTF32LE;
    static Charset csUTF32BE;
    private static Set<Character> unicodeWhiteSpaces;
    private static final Random prng;

    public static boolean hasLength(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static String replaceNewLines(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Replacement string cannot be null");
        }
        if (string2.indexOf(13) >= 0 || string2.indexOf(10) >= 0) {
            throw new IllegalArgumentException("The replacement string cannot contain new-line characters");
        }
        if (string == null) {
            return null;
        }
        if (string.indexOf(13) < 0 && string.indexOf(10) < 0) {
            return string;
        }
        return string.replace("\r\n", string2).replace("\r", string2).replace("\n", string2);
    }

    public static String normalizeNewLines(String string) {
        return string.replace("\r\n", "\n").replace("\r", "\n");
    }

    public static String safe(Object object) {
        return object != null ? object.toString() : "";
    }

    public static String safe(Object object, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return object != null ? object.toString() : string;
    }

    public static String safe2(Object object, String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            return string;
        }
        String string2 = object.toString();
        if (string2.isEmpty()) {
            return string;
        }
        return string2;
    }

    public static String joinList(Iterable<?> iterable) {
        return "[" + Strings.join(", ", iterable) + "]";
    }

    @Deprecated
    public static String join(String string, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Object object : objectArray) {
            if (n2 >= 1) {
                stringBuilder.append(string);
            }
            stringBuilder.append(object == null ? "null" : object.toString());
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String joinv(String string, Object ... objectArray) {
        return Strings.joinv(string, "null", objectArray);
    }

    public static String joinv(String string, String string2, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Object object : objectArray) {
            if (n2 >= 1) {
                stringBuilder.append(string);
            }
            stringBuilder.append(object == null ? string2 : object.toString());
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String join(String string, Iterable<?> iterable) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Object obj : iterable) {
            if (n2 >= 1) {
                stringBuilder.append(string);
            }
            stringBuilder.append(obj == null ? "null" : obj.toString());
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static <T> String join(String string, Iterable<T> iterable, Function<T, CharSequence> function) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (T t : iterable) {
            if (n2 >= 1) {
                stringBuilder.append(string);
            }
            stringBuilder.append(function.apply(t));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String[] stringArray, int n2, int n3) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i < n3; ++i) {
            if (i > n2) {
                stringBuilder.append(string);
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String[] splitLines(String string, boolean bl) {
        if (string.length() < 300 && string.indexOf(10) < 0 && string.indexOf(13) < 0) {
            return new String[]{string};
        }
        return string.split("(\r\n|\r|\n)", bl ? 0 : -1);
    }

    public static String[] splitLines(String string) {
        return Strings.splitLines(string, false);
    }

    public static String[] splitall(String string, String string2) {
        return string.split(string2, -1);
    }

    public static String firstLine(String string) {
        int n2 = Strings.indexOf2(string, '\r', '\n');
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static int search(CharSequence charSequence, int n2, String string, boolean bl, boolean bl2, boolean bl3) {
        if (charSequence == null || string == null) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 > charSequence.length()) {
            return -1;
        }
        if (string.isEmpty()) {
            return n2;
        }
        Pattern pattern = null;
        if (bl) {
            try {
                pattern = Pattern.compile(string, bl2 ? 0 : 2);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (pattern != null) {
            Matcher matcher = pattern.matcher(charSequence);
            if (!bl3) {
                if (matcher.find(n2)) {
                    return matcher.start();
                }
                return -1;
            }
            int n3 = -1;
            while (matcher.find()) {
                int n4 = matcher.start();
                if (n2 > 0 && n4 >= n2) break;
                n3 = n4;
            }
            return n3;
        }
        if (string.length() > charSequence.length()) {
            return -1;
        }
        if (!bl3 && n2 + string.length() > charSequence.length()) {
            return -1;
        }
        if (bl3 && n2 - string.length() < 0) {
            return -1;
        }
        if (bl2 && !bl3) {
            return charSequence.toString().indexOf(string, n2);
        }
        if (!bl2) {
            string = string.toLowerCase();
        }
        char c2 = string.charAt(0);
        String string2 = null;
        if (!bl3) {
            for (int i = n2; i <= charSequence.length() - string.length(); ++i) {
                char c3 = Strings.toLowerCase(charSequence.charAt(i));
                if (c3 != c2) continue;
                if (string2 == null) {
                    string2 = charSequence.toString();
                }
                if (!string.regionMatches(true, 0, string2, i, string.length())) continue;
                return i;
            }
            return -1;
        }
        if (bl2) {
            for (int i = n2 - string.length(); i >= 0; --i) {
                char c4 = charSequence.charAt(i);
                if (c4 != c2) continue;
                if (string2 == null) {
                    string2 = charSequence.toString();
                }
                if (!string.regionMatches(false, 0, string2, i, string.length())) continue;
                return i;
            }
            return -1;
        }
        for (int i = n2 - string.length(); i >= 0; --i) {
            char c5 = Strings.toLowerCase(charSequence.charAt(i));
            if (c5 != c2) continue;
            if (string2 == null) {
                string2 = charSequence.toString();
            }
            if (!string.regionMatches(true, 0, string2, i, string.length())) continue;
            return i;
        }
        return -1;
    }

    private static char toLowerCase(int n2) {
        if (n2 < 127) {
            if (n2 > 90) {
                return (char)n2;
            }
            if (n2 > 64) {
                return (char)(n2 | 0x20);
            }
            if (n2 >= 32) {
                return (char)n2;
            }
        }
        return (char)Character.toLowerCase(n2);
    }

    public static boolean isContainedIn(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean startsWith(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAt(String string, int n2, String string2) {
        if (n2 < 0 || n2 + string2.length() > string.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (string.charAt(n2 + i) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    public static String toString(Object object) {
        return Strings.toString(object, "null");
    }

    public static String toString(Object object, String string) {
        return object == null ? string : object.toString();
    }

    public static String generate(char c2, int n2) {
        if (n2 <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String generate(CharSequence charSequence, int n2) {
        if (n2 <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() * n2);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(charSequence);
        }
        return stringBuilder.toString();
    }

    public static String spaces(int n2) {
        if (n2 <= 0) {
            return "";
        }
        switch (n2) {
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return "   ";
            }
            case 4: {
                return "    ";
            }
            case 5: {
                return "     ";
            }
            case 6: {
                return "      ";
            }
            case 7: {
                return "       ";
            }
            case 8: {
                return "        ";
            }
            case 9: {
                return "         ";
            }
            case 10: {
                return "          ";
            }
        }
        StringBuilder stringBuilder = new StringBuilder("           ");
        for (int i = 0; i < n2 - 11; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public static boolean isBlank(CharSequence charSequence) {
        if (charSequence != null) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (Character.isWhitespace(charSequence.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static int countNonBlankCharacters(CharSequence charSequence) {
        int n2 = 0;
        if (charSequence != null) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (Character.isWhitespace(charSequence.charAt(i))) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static int indexOf(CharSequence charSequence, char c2) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != c2) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf2(CharSequence charSequence, char c2, char c3) {
        return Strings.indexOf2(charSequence, 0, c2, c3);
    }

    public static int indexOf2(CharSequence charSequence, int n2, char c2, char c3) {
        for (int i = n2; i < charSequence.length(); ++i) {
            char c4 = charSequence.charAt(i);
            if (c4 != c2 && c4 != c3) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfAny(CharSequence charSequence, Set<Character> set) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            if (!set.contains(Character.valueOf(c2))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfNotInGroup(CharSequence charSequence, char c2, int n2, char[] ... cArray) {
        int[] nArray = new int[cArray.length];
        block0: for (int i = n2; i < charSequence.length(); ++i) {
            int n3;
            char c3 = charSequence.charAt(i);
            if (c3 == c2) {
                n3 = 1;
                for (int j = 0; j < cArray.length; ++j) {
                    if (nArray[j] == 0) continue;
                    n3 = 0;
                    break;
                }
                if (n3 != 0) {
                    return i;
                }
            }
            for (n3 = 0; n3 < cArray.length; ++n3) {
                if (c3 == cArray[n3][0]) {
                    nArray[n3] = nArray[n3] + 1;
                    continue block0;
                }
                if (c3 != cArray[n3][1]) continue;
                if (nArray[n3] == 0) {
                    return -2;
                }
                nArray[n3] = nArray[n3] - 1;
            }
        }
        return -1;
    }

    public static int lastIndexOf2(CharSequence charSequence, char c2, char c3) {
        return Strings.lastIndexOf2(charSequence, charSequence.length() - 1, c2, c3);
    }

    public static int lastIndexOf2(CharSequence charSequence, int n2, char c2, char c3) {
        for (int i = n2; i >= 0; --i) {
            char c4 = charSequence.charAt(i);
            if (c4 != c2 && c4 != c3) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfAny(CharSequence charSequence, Set<Character> set) {
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            char c2 = charSequence.charAt(i);
            if (!set.contains(Character.valueOf(c2))) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasBlank(CharSequence charSequence) {
        if (charSequence != null) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (!Character.isWhitespace(charSequence.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(char c2) {
        return unicodeWhiteSpaces.contains(Character.valueOf(c2));
    }

    public static boolean isAsciiWhitespace(int n2, char ... cArray) {
        if (n2 == 32 || n2 == 9 || n2 == 13 || n2 == 10) {
            return true;
        }
        if (cArray != null && cArray.length > 0) {
            for (char c2 : cArray) {
                if (n2 != c2) continue;
                return true;
            }
        }
        return false;
    }

    public static String replaceWhitespaces(String string, char c2) {
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c3 = string.charAt(n2);
            if (!Strings.isWhitespace(c3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 < string.length()) {
            char c4 = string.charAt(n2);
            if (Strings.isWhitespace(c4)) {
                stringBuilder.append(c2);
            } else {
                stringBuilder.append(c4);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String trimWhitespaces(String string) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && unicodeWhiteSpaces.contains(Character.valueOf(string.charAt(n2))); ++n2) {
            ++n3;
        }
        n2 = string.length();
        for (int i = n2 - 1; i >= n3 && unicodeWhiteSpaces.contains(Character.valueOf(string.charAt(i))); --i) {
            --n2;
        }
        return string.substring(n3, n2);
    }

    public static String trim(String string) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && string.charAt(n2) <= ' '; ++n2) {
            ++n3;
        }
        n2 = string.length();
        for (int i = n2 - 1; i >= n3 && string.charAt(i) <= ' '; --i) {
            --n2;
        }
        return string.substring(n3, n2);
    }

    public static String trim(String string, char c2) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && string.charAt(n2) == c2; ++n2) {
            ++n3;
        }
        n2 = string.length();
        for (int i = n2 - 1; i >= n3 && string.charAt(i) == c2; --i) {
            --n2;
        }
        return string.substring(n3, n2);
    }

    public static String ltrim(String string) {
        int n2 = 0;
        for (int i = 0; i < string.length() && string.charAt(i) <= ' '; ++i) {
            ++n2;
        }
        return string.substring(n2);
    }

    public static String rtrim(String string) {
        int n2 = string.length();
        for (int i = n2 - 1; i >= 0 && string.charAt(i) <= ' '; --i) {
            --n2;
        }
        return string.substring(0, n2);
    }

    public static String ltrim(String string, char c2) {
        int n2 = 0;
        for (int i = 0; i < string.length() && string.charAt(i) == c2; ++i) {
            ++n2;
        }
        return string.substring(n2);
    }

    public static String rtrim(String string, char c2) {
        int n2 = string.length();
        for (int i = n2 - 1; i >= 0 && string.charAt(i) == c2; --i) {
            --n2;
        }
        return string.substring(0, n2);
    }

    public static int getAsciiLength(byte[] byArray, int n2) {
        byte by;
        int n3;
        for (n3 = 0; n3 < n2 && Characters.isAsciiCharOrCommonFormat(by = byArray[n3]); ++n3) {
        }
        return n3;
    }

    public static int getAsciiLength(byte[] byArray) {
        return Strings.getAsciiLength(byArray, byArray.length);
    }

    public static Charset determinePotentialEncoding(byte[] byArray, int n2, int n3) {
        Charset charset = null;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byte[] byArray2 = new byte[4];
        while (byteBuffer.remaining() >= 4) {
            int n4;
            byArray2[0] = byteBuffer.get();
            byArray2[1] = byteBuffer.get();
            byArray2[2] = byteBuffer.get();
            byArray2[3] = byteBuffer.get();
            if (!(byArray2[0] != 0 ? (byArray2[1] == 0 && byArray2[2] != 0 && byArray2[3] == 0 ? (charset = Strings.setCs(csUTF16LE, charset)) == null : (byArray2[1] == 0 && byArray2[2] == 0 && byArray2[3] == 0 ? (charset = Strings.setCs(csUTF32LE, charset)) == null : (byArray2[1] != 0 && byArray2[2] != 0 && byArray2[3] != 0 ? (Characters.isAsciiChar(byArray2[0]) && Characters.isAsciiChar(byArray2[1]) && Characters.isAsciiChar(byArray2[2]) && Characters.isAsciiChar(byArray2[3]) ? (charset = Strings.setCs(csASCII, charset)) == null : (n4 = EndianUtil.littleEndianBytesToInt(byArray2)) != -1 && (charset = Strings.setCs(csUTF8, charset)) == null) : (byArray2[0] == -1 && byArray2[1] == -2 && byArray2[2] != 0 && byArray2[3] == 0 ? (charset = Strings.setCs(csUTF16, charset)) == null : byArray2[0] == -2 && byArray2[1] == -1 && byArray2[2] == 0 && byArray2[3] != 0 && (charset = Strings.setCs(csUTF16, charset)) == null)))) : (byArray2[1] != 0 && byArray2[2] == 0 && byArray2[3] != 0 ? (charset = Strings.setCs(csUTF16BE, charset)) == null : byArray2[1] == 0 && byArray2[2] == 0 && byArray2[3] != 0 && (charset = Strings.setCs(csUTF32BE, charset)) == null))) continue;
        }
        return charset;
    }

    private static Charset setCs(Charset charset, Charset charset2) {
        if (charset2 == null || charset2 == charset) {
            return charset;
        }
        return null;
    }

    public static boolean isNumber(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String f(String string, Object ... objectArray) {
        return Strings.ff(Locale.US, string, objectArray);
    }

    public static Appendable ff(Locale locale, Appendable appendable, String string, Object ... objectArray) {
        CharSequence charSequence;
        boolean bl = false;
        try {
            charSequence = new StringBuilder(string.length() + objectArray.length * 16);
            int n2 = 0;
            block15: for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c2 != '%') {
                    ((StringBuilder)charSequence).append(c2);
                    continue;
                }
                if (i + 1 == string.length()) {
                    bl = true;
                    break;
                }
                char c3 = string.charAt(i + 1);
                ++i;
                switch (c3) {
                    case '%': {
                        ((StringBuilder)charSequence).append('%');
                        continue block15;
                    }
                    case 'n': {
                        ((StringBuilder)charSequence).append(LINESEP);
                        continue block15;
                    }
                    case 'd': {
                        Object object = objectArray[n2++];
                        if (object instanceof Byte) {
                            ((StringBuilder)charSequence).append(((Byte)object).byteValue());
                            continue block15;
                        }
                        if (object instanceof Short) {
                            ((StringBuilder)charSequence).append(((Short)object).shortValue());
                            continue block15;
                        }
                        if (object instanceof Integer) {
                            ((StringBuilder)charSequence).append((Integer)object);
                            continue block15;
                        }
                        if (object instanceof Long) {
                            ((StringBuilder)charSequence).append((Long)object);
                            continue block15;
                        }
                        bl = true;
                        break block15;
                    }
                    case 'x': {
                        Object object = objectArray[n2++];
                        if (object instanceof Byte) {
                            ((StringBuilder)charSequence).append(Integer.toHexString((Byte)object & 0xFF));
                            continue block15;
                        }
                        if (object instanceof Short) {
                            ((StringBuilder)charSequence).append(Integer.toHexString((Short)object & 0xFFFF));
                            continue block15;
                        }
                        if (object instanceof Integer) {
                            ((StringBuilder)charSequence).append(Integer.toHexString((Integer)object));
                            continue block15;
                        }
                        if (object instanceof Long) {
                            ((StringBuilder)charSequence).append(Long.toHexString((Long)object));
                            continue block15;
                        }
                        bl = true;
                        break block15;
                    }
                    case 'X': {
                        Object object = objectArray[n2++];
                        if (object instanceof Byte) {
                            ((StringBuilder)charSequence).append(Integer.toHexString((Byte)object & 0xFF).toUpperCase());
                            continue block15;
                        }
                        if (object instanceof Short) {
                            ((StringBuilder)charSequence).append(Integer.toHexString((Short)object & 0xFFFF).toUpperCase());
                            continue block15;
                        }
                        if (object instanceof Integer) {
                            ((StringBuilder)charSequence).append(Integer.toHexString((Integer)object).toUpperCase());
                            continue block15;
                        }
                        if (object instanceof Long) {
                            ((StringBuilder)charSequence).append(Long.toHexString((Long)object).toUpperCase());
                            continue block15;
                        }
                        bl = true;
                        break block15;
                    }
                    case 'b': {
                        Object object = objectArray[n2++];
                        ((StringBuilder)charSequence).append((Boolean)object);
                        continue block15;
                    }
                    case 'c': {
                        char c4;
                        Object object = objectArray[n2++];
                        if (object instanceof Character) {
                            c4 = ((Character)object).charValue();
                        } else if (object instanceof Byte) {
                            c4 = (char)((Byte)object).intValue();
                        } else if (object instanceof Short) {
                            c4 = (char)((Short)object).intValue();
                        } else if (object instanceof Integer) {
                            c4 = (char)((Integer)object).intValue();
                        } else {
                            bl = true;
                            break block15;
                        }
                        ((StringBuilder)charSequence).append(c4);
                        continue block15;
                    }
                    case 's': {
                        Object object = objectArray[n2++];
                        if (object instanceof String) {
                            ((StringBuilder)charSequence).append((String)object);
                            continue block15;
                        }
                        ((StringBuilder)charSequence).append(object);
                        continue block15;
                    }
                    default: {
                        int n3;
                        String string2;
                        Object object;
                        if (c3 == '0') {
                            if (i + 1 == string.length()) {
                                bl = true;
                                break block15;
                            }
                            char c5 = string.charAt(i + 1);
                            if ((c5 == '2' || c5 == '4' || c5 == '8') && ++i + 1 < string.length()) {
                                char c6 = string.charAt(i + 1);
                                ++i;
                                object = objectArray[n2++];
                                string2 = null;
                                if (c6 == 'x') {
                                    if (object instanceof Byte) {
                                        string2 = Integer.toHexString((Byte)object & 0xFF);
                                    } else if (object instanceof Short) {
                                        string2 = Integer.toHexString((Short)object & 0xFFFF);
                                    } else if (object instanceof Integer) {
                                        string2 = Integer.toHexString((Integer)object);
                                    } else if (object instanceof Long) {
                                        string2 = Long.toHexString((Long)object);
                                    }
                                } else if (c6 == 'X') {
                                    if (object instanceof Byte) {
                                        string2 = Integer.toHexString((Byte)object & 0xFF).toUpperCase();
                                    } else if (object instanceof Short) {
                                        string2 = Integer.toHexString((Short)object & 0xFFFF).toUpperCase();
                                    } else if (object instanceof Integer) {
                                        string2 = Integer.toHexString((Integer)object).toUpperCase();
                                    } else if (object instanceof Long) {
                                        string2 = Long.toHexString((Long)object).toUpperCase();
                                    }
                                }
                                if (string2 == null) {
                                    bl = true;
                                    break block15;
                                }
                                n3 = c5 - 48;
                                if (string2.length() < n3) {
                                    for (int j = string2.length(); j < n3; ++j) {
                                        ((StringBuilder)charSequence).append('0');
                                    }
                                }
                                ((StringBuilder)charSequence).append(string2);
                                continue block15;
                            }
                            bl = true;
                            break block15;
                        }
                        boolean bl2 = false;
                        if (c3 == '-') {
                            bl2 = true;
                            if (i + 1 == string.length()) {
                                bl = true;
                                break block15;
                            }
                            c3 = string.charAt(i + 1);
                            ++i;
                        }
                        int n4 = 0;
                        while (c3 >= '0' && c3 <= '9' && i + 1 < string.length()) {
                            n4 = n4 * 10 + (c3 - 48);
                            c3 = string.charAt(i + 1);
                            ++i;
                        }
                        if (c3 == 's') {
                            String string3 = string2 = (object = objectArray[n2++]) == null ? "null" : object.toString();
                            if (string2.length() >= n4) {
                                ((StringBuilder)charSequence).append(string2);
                                continue block15;
                            }
                            if (!bl2) {
                                for (n3 = string2.length(); n3 < n4; ++n3) {
                                    ((StringBuilder)charSequence).append(' ');
                                }
                                ((StringBuilder)charSequence).append(string2);
                                continue block15;
                            }
                            ((StringBuilder)charSequence).append(string2);
                            for (n3 = string2.length(); n3 < n4; ++n3) {
                                ((StringBuilder)charSequence).append(' ');
                            }
                            continue block15;
                        }
                        bl = true;
                        break block15;
                    }
                }
            }
            if (!bl) {
                if (objectArray.length != n2) {
                    throw new RuntimeException("Not all format parameters were used! format=" + string + ", params=" + Arrays.toString(objectArray));
                }
                if (appendable == null) {
                    return charSequence;
                }
                appendable.append(charSequence);
                return appendable;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (Exception exception) {}
        charSequence = String.format(locale, string, objectArray);
        if (appendable == null) {
            return new StringBuilder((String)charSequence);
        }
        try {
            appendable.append(charSequence);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return appendable;
    }

    public static Appendable ff(Appendable appendable, String string, Object ... objectArray) {
        return Strings.ff((Locale)null, appendable, string, objectArray);
    }

    public static String ff(Locale locale, String string, Object ... objectArray) {
        return Strings.ff(locale, (Appendable)null, string, objectArray).toString();
    }

    public static String ff(String string, Object ... objectArray) {
        return Strings.ff((Locale)null, (Appendable)null, string, objectArray).toString();
    }

    public static String replaceLast(String string, String string2, String string3) {
        if (Strings.isBlank(string) || Strings.isBlank(string2)) {
            return string;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 >= 0) {
            return string.substring(0, n2) + string3 + string.substring(n2 + string2.length());
        }
        return string;
    }

    public static String substring(String string, int n2, int n3) {
        if (n2 < 0) {
            n2 += string.length();
        }
        if (n3 < 0) {
            n3 += string.length();
        }
        return string.substring(n2, n3);
    }

    public static String truncate(String string, int n2) {
        if (string.length() <= n2) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String truncateWithSuffix(String string, int n2, String string2) {
        if (string2 == null) {
            string2 = "";
        } else if (string2.length() > n2) {
            throw new IllegalArgumentException();
        }
        if (string.length() <= n2) {
            return string;
        }
        return string.substring(0, n2 - string2.length()) + string2;
    }

    public static String indentBlock(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (String string3 : Strings.splitLines(string, true)) {
            if (n2 >= 1) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string2 + string3);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String indentBlock(String string) {
        return Strings.indentBlock(string, "    ");
    }

    public static String urlencodeUTF8(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String urldecodeUTF8(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String[] parseUrlParameters(String string, String ... stringArray) {
        String[] stringArray2 = string.split("&");
        if (stringArray2.length != stringArray.length) {
            return null;
        }
        String[] stringArray3 = new String[stringArray2.length];
        int n2 = 0;
        for (String string2 : stringArray) {
            String[] stringArray4 = stringArray2[n2].split("=");
            if (stringArray4.length != 2 || !string2.equals(stringArray4[0])) {
                return null;
            }
            stringArray3[n2] = stringArray4[1];
            ++n2;
        }
        return stringArray3;
    }

    public static String parseUrlParameter(String string, String string2) {
        return Strings.parseUrlParameters(string, string2)[0];
    }

    public static String encodeArray(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Object object : objectArray) {
            if (n2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Strings.urlencodeUTF8(object.toString()));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String[] decodeArray(String string) {
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        for (String string2 : stringArray) {
            stringArray2[n2] = Strings.urldecodeUTF8(string2);
            ++n2;
        }
        return stringArray2;
    }

    public static String encodeList(List<?> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Object obj : list) {
            if (n2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Strings.urlencodeUTF8(obj.toString()));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static List<String> decodeList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            for (String string2 : string.split(",")) {
                arrayList.add(Strings.urldecodeUTF8(string2));
            }
        }
        return arrayList;
    }

    public static String encodeMap(Map<?, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Object obj : map.keySet()) {
            if (n2 > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(Strings.urlencodeUTF8(obj.toString()) + "=" + Strings.urlencodeUTF8(map.get(obj).toString()));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> decodeMap(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (string != null) {
            for (String string2 : string.split("&")) {
                String[] stringArray = string2.split("=");
                if (stringArray.length != 2) continue;
                linkedHashMap.put(Strings.urldecodeUTF8(stringArray[0]), Strings.urldecodeUTF8(stringArray[1]));
            }
        }
        return linkedHashMap;
    }

    public static byte[] encodeUTF8(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes(Charset.defaultCharset());
        }
    }

    public static String decodeUTF8(byte[] byArray, int n2, int n3) {
        try {
            return new String(byArray, n2, n3, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n2, n3, Charset.defaultCharset());
        }
    }

    public static String decodeUTF8(byte[] byArray) {
        return Strings.decodeUTF8(byArray, 0, byArray.length);
    }

    public static byte[] encodeASCII(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes(Charset.defaultCharset());
        }
    }

    public static String decodeASCII(byte[] byArray, int n2, int n3) {
        try {
            return new String(byArray, n2, n3, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n2, n3, Charset.defaultCharset());
        }
    }

    public static String decodeASCII(byte[] byArray) {
        return Strings.decodeASCII(byArray, 0, byArray.length);
    }

    public static byte[] encodeLocal(String string) {
        return string.getBytes(Charset.defaultCharset());
    }

    public static String decodeLocal(byte[] byArray, int n2, int n3) {
        return new String(byArray, n2, n3, Charset.defaultCharset());
    }

    public static String decodeLocal(byte[] byArray) {
        return Strings.decodeLocal(byArray, 0, byArray.length);
    }

    public static byte[] encodeBinary(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n2 = 0;
        for (char c2 : cArray) {
            byArray[n2++] = (byte)(c2 & 0xFF);
        }
        return byArray;
    }

    public static Comparator<String> getComparator() {
        return Strings.getComparator(true, true);
    }

    public static Comparator<String> getComparator(boolean bl, boolean bl2) {
        return new NumberComparator(new AlphanumCharComparator(bl), bl2);
    }

    public static void makeNewLine(StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        if (n2 == 0) {
            return;
        }
        char c2 = stringBuilder.charAt(n2 - 1);
        if (c2 == '\r' || c2 == '\n') {
            return;
        }
        stringBuilder.append(LINESEP);
    }

    public static String randomUniqueId() {
        byte[] byArray = (prng.nextLong() + "-thxeg73z5tdhgs9c920klaph-" + System.nanoTime()).getBytes(csASCII);
        return Formatter.byteArrayToHexString(Hash.calculateSHA256(byArray), 0, 16).toLowerCase();
    }

    public static CharSequence pad(char c2, int n2) {
        if (n2 <= 0) {
            return "";
        }
        if (n2 == 1) {
            return String.valueOf(c2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(c2);
        }
        return stringBuilder;
    }

    public static String capitalizeFirst(String string) {
        if (string.isEmpty()) {
            return string;
        }
        char c2 = string.charAt(0);
        if (Character.isUpperCase(c2)) {
            return string;
        }
        return Character.toUpperCase(c2) + string.substring(1);
    }

    public static String camelCaseToString(String string, boolean bl, boolean bl2) throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (i == 0 && !Character.isUpperCase(c2) || Character.isWhitespace(c2)) {
                throw new ParseException("Not a legal camel-case string", i);
            }
            if (Character.isUpperCase(c2)) {
                if (i > 0 && !bl4) {
                    stringBuilder.append(' ');
                }
                boolean bl5 = false;
                if (bl2) {
                    if (bl4) {
                        if (i + 1 < string.length() && Character.isUpperCase(string.charAt(i + 1)) && (i + 2 == string.length() || Character.isUpperCase(string.charAt(i + 2)))) {
                            bl5 = true;
                        }
                    } else if (i + 1 < string.length() && Character.isUpperCase(string.charAt(i + 1)) && (i + 2 == string.length() || Character.isUpperCase(string.charAt(i + 2)))) {
                        bl4 = true;
                        bl5 = true;
                    }
                }
                stringBuilder.append(i == 0 || bl4 ? c2 : Character.toLowerCase(c2));
                bl3 = false;
                bl4 = bl5;
                continue;
            }
            if (i > 0 && bl && Character.isDigit(c2) && !bl3) {
                stringBuilder.append(' ');
                stringBuilder.append(c2);
                bl3 = true;
                bl4 = false;
                continue;
            }
            stringBuilder.append(c2);
            bl4 = false;
        }
        return stringBuilder.toString();
    }

    public static String camelCaseToString(String string) throws ParseException {
        return Strings.camelCaseToString(string, false, false);
    }

    public static boolean hasRtl(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            byte by = Character.getDirectionality(c2);
            if (by != 1 && by != 2) continue;
            return true;
        }
        return false;
    }

    public static String[] parseCommandline(String string) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        block4: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n2) {
                case 1: {
                    if ("'".equals(string2)) {
                        bl = true;
                        n2 = 0;
                        continue block4;
                    }
                    stringBuilder.append(string2);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(string2)) {
                        bl = true;
                        n2 = 0;
                        continue block4;
                    }
                    stringBuilder.append(string2);
                    continue block4;
                }
            }
            if ("'".equals(string2)) {
                n2 = 1;
            } else if ("\"".equals(string2)) {
                n2 = 2;
            } else if (" ".equals(string2)) {
                if (bl || stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
            } else {
                stringBuilder.append(string2);
            }
            bl = false;
        }
        if (bl || stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        if (n2 == 1 || n2 == 2) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isWellFormedUTF8(byte[] byArray) {
        return Strings.isWellFormedUTF8(byArray, 0, byArray.length);
    }

    public static boolean isWellFormedUTF8(byte[] byArray, int n2, int n3) {
        String string = new String(byArray, n2, n3, csUTF8);
        return ArrayUtil.equalsBytes(string.getBytes(csUTF8), 0, byArray, n2, n3);
    }

    public static boolean isPrintableUTF8Header(byte[] byArray) {
        return Strings.isPrintableCharsetHeader(byArray, csUTF8);
    }

    public static boolean isPrintableCharsetHeader(byte[] byArray, Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        try {
            CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray));
            return Strings.validateCharBuffer(charBuffer);
        }
        catch (MalformedInputException malformedInputException) {
            int n2 = malformedInputException.getInputLength();
            byte[] byArray2 = new byte[byArray.length - n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            try {
                CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray2));
                return Strings.validateCharBuffer(charBuffer);
            }
            catch (CharacterCodingException characterCodingException) {
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    private static boolean validateCharBuffer(CharBuffer charBuffer) {
        block3: while (charBuffer.hasRemaining()) {
            char c2 = charBuffer.get();
            if (Characters.isAsciiChar(c2) || Character.isAlphabetic(c2) || Character.isWhitespace(c2)) continue;
            switch (Character.getType(c2)) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    continue block3;
                }
            }
            return false;
        }
        return true;
    }

    public static String decodeUTF8Ex(byte[] byArray, boolean bl) {
        return Strings.decodeUTF8Ex(byArray, 0, byArray.length, bl);
    }

    public static String decodeUTF8Ex(byte[] byArray, int n2, int n3, boolean bl) {
        String string = null;
        if (bl && ArrayUtil.equalsBytes((string = new String(byArray, n2, n3, csUTF8)).getBytes(csUTF8), 0, byArray, n2, n3)) {
            return string;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(n3);
            int n4 = n2;
            while (n4 < n2 + n3) {
                int n5;
                int n6;
                int n7;
                int n8;
                if (((n8 = byArray[n4++] & 0xFF) & 0x80) == 0) {
                    n7 = n8 & 0x7F;
                } else if ((n8 & 0xE0) == 192) {
                    if (((n6 = byArray[n4++] & 0xFF) & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    n7 = n6 & 0x3F;
                    n7 |= (n8 & 0x1F) << 6;
                } else if ((n8 & 0xF0) == 224) {
                    if (((n6 = byArray[n4++] & 0xFF) & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    if (((n5 = byArray[n4++] & 0xFF) & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    n7 = n5 & 0x3F;
                    n7 |= (n6 & 0x3F) << 6;
                    n7 |= (n8 & 0xF) << 12;
                } else if ((n8 & 0xF8) == 240) {
                    int n9;
                    if (((n6 = byArray[n4++] & 0xFF) & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    if (((n5 = byArray[n4++] & 0xFF) & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    if (((n9 = byArray[n4++] & 0xFF) & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    n7 = n9 & 0x3F;
                    n7 |= (n5 & 0x3F) << 6;
                    n7 |= (n6 & 0x3F) << 12;
                    n7 |= (n8 & 8) << 18;
                } else {
                    throw new IllegalArgumentException();
                }
                if (!Character.isValidCodePoint(n7)) {
                    throw new IllegalArgumentException();
                }
                stringBuilder.append(Character.toChars(n7));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            if (string == null) {
                string = new String(byArray, n2, n3, csUTF8);
            }
            return string;
        }
    }

    public static int getBOMSize(byte[] byArray) {
        if (byArray.length < 2) {
            return 0;
        }
        if (byArray[0] == -2 && byArray[1] == -1) {
            return 2;
        }
        if (byArray[0] == -1 && byArray[1] == -2) {
            if (byArray.length >= 4 && byArray[2] == 0 && byArray[3] == 0) {
                return 4;
            }
            return 2;
        }
        if (byArray.length < 3) {
            return 0;
        }
        if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return 3;
        }
        if (byArray.length < 4) {
            return 0;
        }
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            return 4;
        }
        return 0;
    }

    public static String readBOM(byte[] byArray) {
        if (byArray.length < 2) {
            return null;
        }
        if (byArray[0] == -2 && byArray[1] == -1) {
            return "UTF-16BE";
        }
        if (byArray[0] == -1 && byArray[1] == -2) {
            if (byArray.length >= 4 && byArray[2] == 0 && byArray[3] == 0) {
                return "UTF-32LE";
            }
            return "UTF-16LE";
        }
        if (byArray.length < 3) {
            return null;
        }
        if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return "UTF-8";
        }
        if (byArray.length < 4) {
            return null;
        }
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            return "UTF-32BE";
        }
        if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            return "UTF-32LE";
        }
        return null;
    }

    public static int getInitialBlankSize(InputStream inputStream, boolean bl, char ... cArray) throws IOException {
        int n2 = 0;
        if (bl) {
            byte[] byArray = new byte[Math.min(4, inputStream.available())];
            inputStream.read(byArray);
            int n3 = Strings.getBOMSize(byArray);
            n2 += n3;
            for (int i = n3; i < byArray.length; ++i) {
                if (Strings.isAsciiWhitespace(byArray[i], cArray)) {
                    ++n2;
                    continue;
                }
                return n2;
            }
        }
        while (Strings.isAsciiWhitespace(inputStream.read(), cArray)) {
            ++n2;
        }
        return n2;
    }

    public static int count(String string, char c2) {
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(c2, n3)) >= 0) {
            ++n3;
            ++n2;
        }
        return n2;
    }

    public static int count(String string, String string2, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n3)) >= 0) {
            n3 = bl ? ++n3 : (n3 += string2.length());
            ++n2;
        }
        return n2;
    }

    public static boolean like(String string, String string2) {
        return Pattern.compile(string2).matcher(string).matches();
    }

    public static boolean likei(String string, String string2) {
        return Pattern.compile(string2, 2).matcher(string).matches();
    }

    public static boolean starMatches(String string, String string2) {
        return new StarMatcher(string2).matches(string);
    }

    public static int[] findWordBoundaries(String string, int n2) {
        return Strings.findWordBoundaries(string, n2, null);
    }

    public static int[] findWordBoundaries(String string, int n2, Predicate<Character> predicate) {
        char c2;
        int n3;
        int n4;
        char c3;
        boolean bl;
        if (n2 < 0 || n2 >= string.length()) {
            return new int[]{n2, n2};
        }
        if (predicate == null) {
            predicate = Strings::isBound;
        }
        if (bl = Character.isWhitespace(c3 = string.charAt(n2))) {
            n4 = n2;
        } else {
            for (n3 = n2; n3 > 0 && !predicate.test(Character.valueOf(c2 = string.charAt(n3 - 1))); --n3) {
            }
            n4 = n3;
        }
        if (bl) {
            for (n3 = n2; n3 < string.length() && Character.isWhitespace(c2 = string.charAt(n3)); ++n3) {
            }
        }
        while (n3 < string.length() && !predicate.test(Character.valueOf(c2 = string.charAt(n3)))) {
            ++n3;
        }
        return new int[]{n4, n3};
    }

    private static boolean isBound(char c2) {
        if (Character.isWhitespace(c2)) {
            return true;
        }
        int n2 = Character.getType(c2);
        return n2 == 21 || n2 == 22 || n2 == 24;
    }

    static {
        String string = System.getProperty("line.separator");
        if (string == null && (string = Strings.ff("%n", new Object[0])) == null) {
            throw new RuntimeException("Cannot determine line separator for this platform");
        }
        LINESEP = string;
        csASCII = Charset.forName("ASCII");
        csUTF8 = Charset.forName("UTF-8");
        csUTF16 = Charset.forName("UTF-16");
        csUTF16LE = Charset.forName("UTF-16LE");
        csUTF16BE = Charset.forName("UTF-16BE");
        csUTF32LE = Charset.forName("UTF-32LE");
        csUTF32BE = Charset.forName("UTF-32BE");
        unicodeWhiteSpaces = new HashSet<Character>();
        unicodeWhiteSpaces.add(Character.valueOf('\t'));
        unicodeWhiteSpaces.add(Character.valueOf('\n'));
        unicodeWhiteSpaces.add(Character.valueOf('\u000b'));
        unicodeWhiteSpaces.add(Character.valueOf('\f'));
        unicodeWhiteSpaces.add(Character.valueOf('\r'));
        unicodeWhiteSpaces.add(Character.valueOf(' '));
        unicodeWhiteSpaces.add(Character.valueOf('\u0085'));
        unicodeWhiteSpaces.add(Character.valueOf('\u00a0'));
        unicodeWhiteSpaces.add(Character.valueOf('\u1680'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2000'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2001'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2002'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2003'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2004'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2005'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2006'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2007'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2008'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2009'));
        unicodeWhiteSpaces.add(Character.valueOf('\u200a'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2028'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2029'));
        unicodeWhiteSpaces.add(Character.valueOf('\u202f'));
        unicodeWhiteSpaces.add(Character.valueOf('\u205f'));
        unicodeWhiteSpaces.add(Character.valueOf('\u3000'));
        prng = new Random();
    }
}

