/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class PrettyPrinter {
    public static final int DEFAULT_MAX_STRING_LENGTH = 200;
    public static final int DEFAULT_MAX_ARRAY_ITEM_COUNT = 40;
    public static final int DEFAULT_MAX_COLLECTION_ITEM_COUNT = 40;
    public static final int DEFAULT_MAX_MAP_ITEM_COUNT = 40;
    private int maxEltsPerString = 200;
    private int maxEltsPerArray = 40;
    private int maxEltsPerColl = 40;
    private int maxEltsPerMap = 40;
    private boolean allowUnsafeCalls;
    private boolean newlinesForMaps;
    private String indentString;

    public PrettyPrinter(boolean bl, int n2) {
        this.allowUnsafeCalls = bl;
        if (n2 < 0) {
            this.newlinesForMaps = false;
            this.indentString = "";
        } else {
            this.newlinesForMaps = true;
            this.indentString = Strings.spaces(n2);
        }
    }

    public PrettyPrinter(boolean bl) {
        this(bl, 2);
    }

    public PrettyPrinter() {
        this(true, 2);
    }

    public void setMaxStringLength(int n2) {
        this.maxEltsPerString = n2;
    }

    public void setMaxArrayLength(int n2) {
        this.maxEltsPerArray = n2;
    }

    public void setMaxCollectionLength(int n2) {
        this.maxEltsPerColl = n2;
    }

    public void setMaxMapLength(int n2) {
        this.maxEltsPerMap = n2;
    }

    public String format(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(object, stringBuilder, 0, false);
        return stringBuilder.toString();
    }

    private void toString(Object object, StringBuilder stringBuilder, int n2, boolean bl) {
        if (!bl && n2 > 0 && stringBuilder.length() > 1 && stringBuilder.charAt(stringBuilder.length() - 1) == '\n') {
            this.indent(n2, stringBuilder);
        }
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof Character) {
            Strings.ff(stringBuilder, "'%s'", Formatter.escapeCharacter(((Character)object).charValue()));
        } else if (object instanceof Boolean || object instanceof Integer || object instanceof Double) {
            Strings.ff(stringBuilder, "%s", object);
        } else if (object instanceof Byte) {
            Strings.ff(stringBuilder, "%d", object);
        } else if (object instanceof Short) {
            Strings.ff(stringBuilder, "%d", object);
        } else if (object instanceof Long) {
            Strings.ff(stringBuilder, "%sL", object);
        } else if (object instanceof Float) {
            Strings.ff(stringBuilder, "%sF", object);
        } else if (object instanceof String) {
            Object object2 = (String)object;
            if (((String)object2).length() > this.maxEltsPerString) {
                object2 = ((String)object2).substring(0, this.maxEltsPerString) + "...";
            }
            Strings.ff(stringBuilder, "\"%s\"", Formatter.escapeString((CharSequence)object2));
        } else if (object.getClass().isArray()) {
            boolean bl2 = false;
            int n3 = Array.getLength(object);
            if (n3 > this.maxEltsPerArray) {
                n3 = this.maxEltsPerArray;
                bl2 = true;
            }
            stringBuilder.append('(');
            for (int i = 0; i < n3; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                Object object3 = Array.get(object, i);
                this.toString(object3, stringBuilder, n2, true);
            }
            if (bl2) {
                stringBuilder.append(", ...");
            }
            stringBuilder.append(')');
        } else {
            boolean bl3;
            boolean bl4 = bl3 = this.allowUnsafeCalls || object.getClass().getName().startsWith("java.");
            if (!bl3) {
                String string = this.formatObject(object);
                if (string == null) {
                    string = "?";
                }
                stringBuilder.append(string);
            } else if (object instanceof CharSequence) {
                Object object4 = ((CharSequence)object).toString();
                if (((String)object4).length() > this.maxEltsPerString) {
                    object4 = ((String)object4).substring(0, this.maxEltsPerString) + "...";
                }
                Strings.ff(stringBuilder, "\"%s\"", Formatter.escapeString((CharSequence)object4));
            } else if (object instanceof Map) {
                Map map = (Map)object;
                stringBuilder.append('{');
                if (!map.isEmpty()) {
                    boolean bl5 = false;
                    int n4 = map.size();
                    if (n4 > this.maxEltsPerMap) {
                        n4 = this.maxEltsPerMap;
                        bl5 = true;
                    }
                    if (this.newlinesForMaps) {
                        stringBuilder.append('\n');
                    }
                    int n5 = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        this.toString(entry.getKey(), stringBuilder, n2 + 1, false);
                        stringBuilder.append(": ");
                        this.toString(entry.getValue(), stringBuilder, n2 + 1, true);
                        if (++n5 < map.size()) {
                            stringBuilder.append(',');
                        }
                        if (this.newlinesForMaps) {
                            stringBuilder.append('\n');
                        } else {
                            stringBuilder.append(' ');
                        }
                        if (n5 < n4) continue;
                        break;
                    }
                    this.indent(n2, stringBuilder);
                    if (bl5) {
                        stringBuilder.append(", ...");
                    }
                }
                stringBuilder.append('}');
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                stringBuilder.append('[');
                if (!collection.isEmpty()) {
                    boolean bl6 = false;
                    int n6 = collection.size();
                    if (n6 > this.maxEltsPerColl) {
                        n6 = this.maxEltsPerColl;
                        bl6 = true;
                    }
                    int n7 = 0;
                    for (Object e : collection) {
                        if (n7 > 0) {
                            stringBuilder.append(", ");
                        }
                        this.toString(e, stringBuilder, n2, true);
                        if (++n7 < n6) continue;
                        break;
                    }
                    if (bl6) {
                        stringBuilder.append(", ...");
                    }
                }
                stringBuilder.append(']');
            } else {
                Object object5 = this.formatObject(object);
                if (object5 != null) {
                    stringBuilder.append((String)object5);
                } else {
                    object5 = object.toString();
                    if (((String)object5).length() > this.maxEltsPerString) {
                        object5 = ((String)object5).substring(0, this.maxEltsPerString) + "...";
                    }
                    Strings.ff(stringBuilder, "`%s`", Formatter.escapeString((CharSequence)object5));
                }
            }
        }
    }

    private void indent(int n2, StringBuilder stringBuilder) {
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(this.indentString);
        }
    }

    protected String formatObject(Object object) {
        return null;
    }
}

