/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.collect.ISegment;
import com.pnfsoftware.jeb.util.collect.SegmentMap;
import com.pnfsoftware.jeb.util.format.PrettyPrinter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.primitives.Characters;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;

public class Formatter {
    private static SegmentMap<Character, CharSegment> rangesCharsPrintable;
    private static SegmentMap<Character, CharSegment> rangesCharsNonPrintable;

    public static CharSequence formatBinaryBlock(byte[] byArray, int n2, int n3, long l2, boolean bl) {
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = n2;
        for (int i = n3; i > 0; i -= n4) {
            int n6;
            if (bl) {
                stringBuilder.append(Formatter.toHexString((long)n5 - l2, true, 16)).append("  ");
            } else {
                stringBuilder.append(Formatter.toHexString(n5 - (int)l2, true, 8)).append("  ");
            }
            for (n6 = 0; n6 < 16 && n6 < i; ++n6) {
                stringBuilder.append(Formatter.toHexString(byArray[n5 + n6], true, 2)).append(" ");
            }
            n4 = n6;
            while (n6 < 16) {
                stringBuilder.append("   ");
                ++n6;
            }
            stringBuilder.append(" ");
            for (n6 = 0; n6 < n4; ++n6) {
                byte by = byArray[n5 + n6];
                if (Characters.isAsciiChar(by)) {
                    stringBuilder.append((char)by);
                    continue;
                }
                stringBuilder.append(".");
            }
            stringBuilder.append("\n");
            n5 += n4;
        }
        return stringBuilder;
    }

    public static CharSequence formatBinaryBlock(byte[] byArray, int n2, int n3, int n4) {
        return Formatter.formatBinaryBlock(byArray, n2, n3, n4, false);
    }

    public static CharSequence formatBinaryBlock(byte[] byArray, int n2, int n3) {
        return Formatter.formatBinaryBlock(byArray, n2, n3, 0);
    }

    public static CharSequence formatBinaryBlock(byte[] byArray) {
        return Formatter.formatBinaryBlock(byArray, 0, byArray.length);
    }

    public static CharSequence formatBinaryLine(byte[] byArray, int n2, int n3, int n4) {
        return Formatter.formatBinaryLine(byArray, n2, n3, n4, true);
    }

    public static CharSequence formatBinaryLine(byte[] byArray, int n2, int n3, int n4, boolean bl) {
        int n5;
        StringBuilder stringBuilder = new StringBuilder();
        for (n5 = 0; n5 < n3; ++n5) {
            stringBuilder.append(Formatter.toHexString(byArray[n2 + n5], true, 2));
            if (!bl) continue;
            stringBuilder.append(" ");
        }
        while (n5 < n4) {
            stringBuilder.append("   ");
            ++n5;
        }
        return stringBuilder;
    }

    public static CharSequence formatBinaryLine(byte[] byArray, int n2, int n3) {
        return Formatter.formatBinaryLine(byArray, n2, n3, n3);
    }

    public static CharSequence formatBinaryLine(byte[] byArray) {
        return Formatter.formatBinaryLine(byArray, 0, byArray.length, 0);
    }

    public static CharSequence formatBinaryLineTruncate(byte[] byArray, int n2, int n3, int n4, char c2) {
        int n5;
        StringBuilder stringBuilder = new StringBuilder();
        int n6 = n3 <= n4 ? n3 : n4;
        for (n5 = 0; n5 < n6; ++n5) {
            if (n5 >= 1) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(Formatter.toHexString(byArray[n2 + n5], true, 2));
        }
        if (n3 <= n4) {
            stringBuilder.append(" ");
            while (n5 < n4) {
                stringBuilder.append("   ");
                ++n5;
            }
        } else {
            stringBuilder.append(c2);
        }
        return stringBuilder;
    }

    public static CharSequence formatBinaryLineTruncate(byte[] byArray, int n2, int n3, int n4) {
        return Formatter.formatBinaryLineTruncate(byArray, n2, n3, n4, '+');
    }

    public static CharSequence byteArrayToHex(byte[] byArray) {
        return Formatter.byteArrayToHex(byArray, 0, byArray.length);
    }

    public static String byteArrayToHexString(byte[] byArray) {
        return Formatter.byteArrayToHexString(byArray, 0, byArray.length);
    }

    public static String byteArrayToHexString(byte[] byArray, int n2) {
        return Formatter.byteArrayToHexString(byArray, n2, byArray.length);
    }

    public static String byteArrayToHexString(byte[] byArray, int n2, int n3) {
        return Formatter.byteArrayToHex(byArray, n2, n3).toString();
    }

    public static CharSequence byteArrayToHex(byte[] byArray, int n2, int n3) {
        return Formatter.byteArrayToHex(byArray, n2, n3, false, 0);
    }

    public static CharSequence byteArrayToHex(byte[] byArray, int n2, int n3, boolean bl, int n4) {
        if (byArray == null || n2 < 0 || n3 > byArray.length || n2 > n3) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = n2;
        for (int i = n2; i < n3; ++i) {
            stringBuilder.append(Formatter.toHexString(byArray[i], true, 2));
            if (bl && ((i - n2) % n4 == n4 - 1 || i == n3 - 1)) {
                if (i == n3 - 1) {
                    stringBuilder.append(Strings.pad(' ', 2 * (n4 - (i - n2) % n4 - 1)));
                }
                stringBuilder.append("  ");
                for (int j = 0; j < n4 && n5 + j < n3; ++j) {
                    if (Characters.isAsciiChar(byArray[n5 + j])) {
                        stringBuilder.append((char)byArray[n5 + j]);
                        continue;
                    }
                    stringBuilder.append(".");
                }
                n5 = i + 1;
            }
            if (n4 <= 0 || (i - n2) % n4 != n4 - 1 || i + 1 == n3) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder;
    }

    public static byte[] hexStringToByteArray(String string, int n2, int n3) {
        if (n2 < 0 || n2 > n3 || (n3 - n2) % 2 != 0) {
            return null;
        }
        int n4 = (n3 - n2) / 2;
        byte[] byArray = new byte[n4];
        for (int i = 0; i < n4; ++i) {
            try {
                byArray[i] = (byte)Integer.parseInt(string.substring(n2, n2 + 2), 16);
                n2 += 2;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return byArray;
    }

    public static byte[] hexStringToByteArray(String string) {
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = string.length();
        if (string.endsWith("h")) {
            --n3;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            n2 += 2;
        }
        return Formatter.hexStringToByteArray(string, n2, n3);
    }

    public static void addCustomPrintableCharRange(char c2, char c3, boolean bl) {
        if (bl) {
            if (rangesCharsPrintable == null) {
                rangesCharsPrintable = new SegmentMap();
            }
            rangesCharsPrintable.add(new CharSegment(Character.valueOf(c2), Character.valueOf(c3)));
        } else {
            if (rangesCharsNonPrintable == null) {
                rangesCharsNonPrintable = new SegmentMap();
            }
            rangesCharsNonPrintable.add(new CharSegment(Character.valueOf(c2), Character.valueOf(c3)));
        }
    }

    public static void resetCustomPrintableCharRanges() {
        rangesCharsPrintable = null;
        rangesCharsNonPrintable = null;
    }

    public static boolean isPrintableChar(char c2) {
        if (Character.isISOControl(c2)) {
            return false;
        }
        if (Character.isSurrogate(c2)) {
            return false;
        }
        if (rangesCharsNonPrintable != null && rangesCharsNonPrintable.getSegmentContaining(Character.valueOf(c2)) != null) {
            return false;
        }
        if (rangesCharsPrintable != null && rangesCharsPrintable.getSegmentContaining(Character.valueOf(c2)) != null) {
            return true;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
        if (unicodeBlock == null) {
            return false;
        }
        return unicodeBlock != Character.UnicodeBlock.SPECIALS;
    }

    public static String escapeCharacter(char c2, boolean bl) {
        if (c2 == '\'') {
            return "\\'";
        }
        if (c2 == '\"') {
            return "\\\"";
        }
        if (c2 == '\\') {
            return "\\\\";
        }
        if (bl && Formatter.isPrintableChar(c2)) {
            return Character.toString(c2);
        }
        if (c2 >= '\u007f') {
            return "\\u" + Formatter.toHexString(c2, true, 4);
        }
        if (c2 >= ' ') {
            return Character.toString(c2);
        }
        if (c2 == '\n') {
            return "\\n";
        }
        if (c2 == '\r') {
            return "\\r";
        }
        if (c2 == '\t') {
            return "\\t";
        }
        if (c2 == '\b') {
            return "\\b";
        }
        if (c2 == '\f') {
            return "\\f";
        }
        return "\\u" + Formatter.toHexString(c2, true, 4);
    }

    public static String escapeCharacter(char c2) {
        return Formatter.escapeCharacter(c2, true);
    }

    public static String escapeString(CharSequence charSequence) {
        return Formatter.escapeString(charSequence, true);
    }

    public static String escapeString(CharSequence charSequence, boolean bl) {
        return Formatter.escapeString(charSequence, 0, bl, null);
    }

    public static String escapeString(CharSequence charSequence, int n2, boolean bl, Set<Character> set) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        if (n2 != -1) {
            if (n2 == 0) {
                if (Strings.hasRtl(charSequence)) {
                    bl = false;
                }
            } else if (bl && Strings.hasRtl(charSequence)) {
                if (n2 == 1) {
                    stringBuilder.append('\u202a');
                } else if (n2 == 2) {
                    stringBuilder.append('\u202b');
                } else {
                    throw new IllegalArgumentException("Illegal directionality argument: " + n2);
                }
                bl2 = true;
            }
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            if (Characters.isAsciiChar(c2) && c2 != '\'' && c2 != '\\' && c2 != '\"') {
                stringBuilder.append(c2);
                continue;
            }
            if (set != null && set.contains(Character.valueOf(c2))) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(Formatter.escapeCharacter(c2, bl));
        }
        if (bl2) {
            stringBuilder.append('\u202c');
        }
        return stringBuilder.toString();
    }

    public static String unescapeString(String string) throws ParseException {
        Object object = "";
        int n2 = 0;
        while (n2 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n2++)) == '\\') {
                int n3;
                if (n2 >= string.length()) {
                    throw new ParseException("String too short, need 1 char for escape", n2);
                }
                if ((c2 = string.charAt(n2++)) == '\\') {
                    object = (String)object + "\\";
                    continue;
                }
                if (c2 == '\"') {
                    object = (String)object + "\"";
                    continue;
                }
                if (c2 == '\'') {
                    object = (String)object + "'";
                    continue;
                }
                if (c2 == 'n') {
                    object = (String)object + "\n";
                    continue;
                }
                if (c2 == 'r') {
                    object = (String)object + "\r";
                    continue;
                }
                if (c2 == 't') {
                    object = (String)object + "\t";
                    continue;
                }
                if (c2 == 'b') {
                    object = (String)object + "\b";
                    continue;
                }
                if (c2 == 'f') {
                    object = (String)object + "\f";
                    continue;
                }
                if (c2 == 'u') {
                    if (n2 + 4 > string.length()) {
                        throw new ParseException("String too short, need 4 chars for escape", n2);
                    }
                    n3 = Integer.parseInt(string.substring(n2, n2 + 4), 16);
                    n2 += 4;
                    object = (String)object + Character.valueOf((char)n3);
                    continue;
                }
                if (c2 == 'x') {
                    if (n2 + 2 > string.length()) {
                        throw new ParseException("String too short, need 2 chars for escape", n2);
                    }
                    n3 = Integer.parseInt(string.substring(n2, n2 + 2), 16);
                    n2 += 2;
                    object = (String)object + Character.valueOf((char)n3);
                    continue;
                }
                throw new ParseException("Unknown escape: " + c2, n2);
            }
            object = (String)object + c2;
        }
        return object;
    }

    public static String escapeAllCharacters(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            stringBuilder.append("\\u").append(Formatter.toHexString(c2, true, 4));
        }
        return stringBuilder.toString();
    }

    public static String escapeToJavaStringArray(Collection<? extends Object> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("new String[]{\n");
        for (Object object : collection) {
            if (object == null) {
                stringBuilder.append("    null,\n");
                continue;
            }
            stringBuilder.append("    \"").append(Formatter.escapeString(object.toString())).append("\",\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String escapeBytes(byte[] byArray, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i < n2 + n3; ++i) {
            stringBuilder.append(Formatter.escapeCharacter((char)(byArray[i] & 0xFF), false));
        }
        return stringBuilder.toString();
    }

    public static String escapeBytes(byte[] byArray) {
        return Formatter.escapeBytes(byArray, 0, byArray.length);
    }

    public static String escapeByte(int n2) {
        return Formatter.escapeBytes(new byte[]{(byte)n2});
    }

    public static String formatHexNumbers(Collection<? extends Number> collection) {
        return Formatter.formatNumbers(collection, 16, null, null);
    }

    public static String formatNumbers(Collection<? extends Number> collection, int n2, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("[");
        int n3 = 0;
        string = Strings.safe(string);
        string2 = Strings.safe(string2);
        if (n2 == 8) {
            for (Number number : collection) {
                if (n3 >= 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string).append(Long.toOctalString(number.longValue())).append(string2);
                ++n3;
            }
        } else if (n2 == 10) {
            for (Number number : collection) {
                if (n3 >= 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string).append(number.longValue()).append(string2);
                ++n3;
            }
        } else if (n2 == 16) {
            for (Number number : collection) {
                if (n3 >= 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string).append(Long.toHexString(number.longValue()).toUpperCase()).append(string2);
                ++n3;
            }
        } else {
            throw new IllegalArgumentException("Invalid base: " + n2);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String integerToAlphaString(int n2) {
        Object object = "";
        boolean bl = false;
        if (n2 < 0) {
            n2 = -n2;
            bl = true;
        }
        int n3 = 1;
        int n4 = 26;
        while (n2 >= n4) {
            n2 -= n4;
            n4 *= 26;
            ++n3;
        }
        for (int i = 0; i < n3; ++i) {
            int n5 = n2 % 26;
            n2 /= 26;
            object = (char)(97 + n5) + (String)object;
        }
        return bl ? "-" + (String)object : object;
    }

    public static String toHexString(long l2, boolean bl, int n2) {
        Object object = Formatter.toHexString(l2, bl);
        if (((String)object).length() < n2) {
            object = Strings.pad('0', n2 - ((String)object).length()) + (String)object;
        }
        return object;
    }

    public static String toHexString(long l2, boolean bl) {
        String string = Long.toHexString(l2);
        if (bl) {
            string = string.toUpperCase();
        }
        return string;
    }

    public static String toHexString(int n2, boolean bl, int n3) {
        Object object = Formatter.toHexString(n2, bl);
        if (((String)object).length() < n3) {
            object = Strings.pad('0', n3 - ((String)object).length()) + (String)object;
        }
        return object;
    }

    public static String toHexString(int n2, boolean bl) {
        String string = Integer.toHexString(n2);
        if (bl) {
            string = string.toUpperCase();
        }
        return string;
    }

    public static String toHexString(short s2, boolean bl, int n2) {
        return Formatter.toHexString(s2 & 0xFFFF, bl, n2);
    }

    public static String toHexString(short s2, boolean bl) {
        return Formatter.toHexString(s2 & 0xFFFF, bl);
    }

    public static String toHexString(byte by, boolean bl, int n2) {
        return Formatter.toHexString(by & 0xFF, bl, n2);
    }

    public static String toHexString(byte by, boolean bl) {
        return Formatter.toHexString(by & 0xFF, bl);
    }

    public static String htmlEscape(String string) {
        return Formatter.htmlEscape(string, false);
    }

    public static String htmlEscape(String string, boolean bl) {
        string = StringEscapeUtils.escapeHtml4((String)string);
        if (bl) {
            string = string.replaceAll("\r|\r\n|\n", "<br>\n");
        }
        return string;
    }

    public static List<String> wordWrap(String string, int n2, int n3) {
        if (string == null) {
            throw new IllegalArgumentException("Null string");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid wrapping length: " + n2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : Strings.splitLines(string)) {
            int n4 = 0;
            int n5 = Integer.MAX_VALUE;
            for (int i = 0; i < string2.length(); ++i) {
                boolean bl2;
                char c2 = string2.charAt(i);
                boolean bl3 = bl2 = Character.getType(c2) == 12;
                if (bl2) {
                    n5 = i;
                }
                stringBuilder.append(c2);
                if (stringBuilder.length() >= n2) {
                    if (n3 == 0) {
                        bl = true;
                    } else if (n3 > 0) {
                        bl = bl2;
                    } else {
                        if (!bl2 && n5 - n4 < n2) {
                            stringBuilder.setLength(n5 - n4 + 1);
                            i = n5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                bl = false;
                n4 = i + 1;
            }
            if (stringBuilder.length() <= 0) continue;
            arrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
            bl = false;
        }
        return arrayList;
    }

    public static String toString(Object object) {
        return new PrettyPrinter(true, 2).format(object);
    }

    @SerDisabled
    private static class CharSegment
    implements ISegment<Character> {
        private Character begin;
        private Character end;

        public CharSegment(Character c2, Character c3) {
            this.begin = c2;
            this.end = c3;
        }

        @Override
        public Character getBegin() {
            return this.begin;
        }

        @Override
        public Character getEnd() {
            return this.end;
        }
    }
}

