/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.events;

import com.pnfsoftware.jeb.util.events.Event;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.events.IEventSource;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Ser
public class EventSource
implements IEventSource {
    private static final ILogger logger = GlobalLog.getLogger(EventSource.class);
    @SerTransient
    private List<IEventListener> listeners;
    @SerTransient
    private volatile IEventSource parentSource;

    @SerCustomInit
    private void init() {
        this.listeners = new CopyOnWriteArrayList<IEventListener>();
    }

    public EventSource() {
        this(null);
    }

    public EventSource(EventSource eventSource) {
        this.parentSource = eventSource;
        this.init();
    }

    @Override
    public void setParentSource(IEventSource iEventSource) {
        this.parentSource = iEventSource;
    }

    @Override
    public IEventSource getParentSource() {
        return this.parentSource;
    }

    @Override
    public int countListeners() {
        return this.listeners.size();
    }

    public List<IEventListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void addListener(IEventListener iEventListener) {
        if (iEventListener != null) {
            this.listeners.add(iEventListener);
        }
    }

    @Override
    public void insertListener(int n2, IEventListener iEventListener) {
        if (iEventListener != null) {
            this.listeners.add(n2, iEventListener);
        }
    }

    @Override
    public void removeListener(IEventListener iEventListener) {
        if (iEventListener != null) {
            this.listeners.remove(iEventListener);
        }
    }

    @Override
    public void notifyListeners(IEvent iEvent) {
        if (!(iEvent instanceof Event)) {
            for (IEventListener iEventListener : this.listeners) {
                iEventListener.onEvent(iEvent);
            }
        } else {
            this.notifyListeners((Event)iEvent);
        }
    }

    public void notifyListeners(Event event) {
        this.notifyListeners(event, true);
    }

    public void notifyListeners(Event event, boolean bl) {
        if (event.source == null) {
            event.source = this;
        }
        if (bl && this.parentSource != null && this.parentSource != this && event.source != this.parentSource && !event.notifiedParents.contains(this.parentSource)) {
            event.notifiedParents.add(this.parentSource);
            this.parentSource.notifyListeners(event);
        }
        for (IEventListener iEventListener : this.listeners) {
            if (event.source == iEventListener || event.notifiedListeners.contains(iEventListener)) continue;
            event.notifiedListeners.add(iEventListener);
            iEventListener.onEvent(event);
            if (!event.stopPropagation) continue;
            break;
        }
    }

    public static IEventListener relay(IEventSource iEventSource, final IEventSource iEventSource2) {
        if (iEventSource == null || iEventSource2 == null) {
            throw new RuntimeException("Event source is null");
        }
        IEventListener iEventListener = new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                iEventSource2.notifyListeners(iEvent);
            }
        };
        iEventSource.addListener(iEventListener);
        return iEventListener;
    }
}

