/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.events;

import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AggregatorDispatcher
implements IEventListener {
    private static final ILogger logger = GlobalLog.getLogger(AggregatorDispatcher.class, Integer.MAX_VALUE);
    private Set<IEvent> list = new LinkedHashSet<IEvent>();
    private Object lockNotify = new Object();
    private int capacity;
    private long resolution;

    public AggregatorDispatcher() {
        this(100, 250L);
    }

    public AggregatorDispatcher(int n2, long l2) {
        if (n2 <= 0 || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        this.capacity = n2;
        this.resolution = l2;
        if (l2 != 0L) {
            ThreadUtil.start(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Set<IEvent> set = AggregatorDispatcher.this.list;
                                synchronized (set) {
                                    while (AggregatorDispatcher.this.list.isEmpty()) {
                                        AggregatorDispatcher.this.list.wait();
                                    }
                                }
                                Thread.sleep(AggregatorDispatcher.this.resolution);
                                AggregatorDispatcher.this.trigger();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            });
        }
    }

    private void enqueue(IEvent iEvent) {
        boolean bl;
        Set<IEvent> set = this.list;
        synchronized (set) {
            boolean bl2 = this.list.add(iEvent);
            if (!bl2) {
                return;
            }
            int n2 = this.list.size();
            if (n2 == 1) {
                this.list.notify();
            }
            bl = n2 >= this.capacity;
        }
        if (bl) {
            this.trigger();
        }
    }

    private void trigger() {
        ArrayList<IEvent> arrayList = null;
        Object object = this.list;
        synchronized (object) {
            if (!this.list.isEmpty()) {
                arrayList = new ArrayList<IEvent>(this.list);
                this.list.clear();
            }
        }
        if (arrayList != null) {
            object = this.lockNotify;
            synchronized (object) {
                Object[] objectArray = new Object[]{arrayList.size(), this.capacity};
                this.onMultipleEvents(arrayList);
            }
        }
    }

    @Override
    public void onEvent(IEvent iEvent) {
        this.enqueue(iEvent);
    }

    public int unattended() {
        Set<IEvent> set = this.list;
        synchronized (set) {
            return this.list.size();
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public long resolution() {
        return this.resolution;
    }

    public abstract void onMultipleEvents(List<IEvent> var1);
}

