/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.encoding.zip.fsr.CentralDirFileHeader;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.EndOfCentralDir;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.LocalFileHeader;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.ZipData;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.ZipEntry;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ZipFailSafeReader
implements AutoCloseable {
    private static final ILogger logger = GlobalLog.getLogger(ZipFailSafeReader.class);
    static final byte[] MAGIC_CENTRALDIR_FILEHDR = new byte[]{80, 75, 1, 2};
    static final byte[] MAGIC_LOCAL_FILEHDR = new byte[]{80, 75, 3, 4};
    static final byte[] MAGIC_END_OF_CENTRALDIR = new byte[]{80, 75, 5, 6};
    static final byte[] MAGIC_DATA = new byte[]{80, 75, 7, 8};
    static final int STORED = 0;
    static final int DEFLATED = 8;
    private boolean treatUnsupportedCompressionAsDeflate;
    private boolean ignoreEncryption;
    private boolean recoveryMode;
    private SeekableByteChannel channel;
    private int archsize;
    private ByteBuffer tmpPage;
    private EndOfCentralDir eocr;
    private Boolean parsingComplete;
    private List<ZipEntry> entries = new ArrayList<ZipEntry>();
    private Map<String, ZipEntry> map = new LinkedHashMap<String, ZipEntry>();
    private int offsetFirstEntry = Integer.MAX_VALUE;
    private int offsetAppendedData;

    public ZipFailSafeReader(File file) throws IOException {
        this(file, false, false, false, false);
    }

    public ZipFailSafeReader(SeekableByteChannel seekableByteChannel) throws IOException {
        this(seekableByteChannel, false, false, false, false);
    }

    public ZipFailSafeReader(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        this(FileChannel.open(file.toPath(), StandardOpenOption.READ), bl, bl2, bl3, bl4);
    }

    public ZipFailSafeReader(SeekableByteChannel seekableByteChannel, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        this.channel = seekableByteChannel;
        this.treatUnsupportedCompressionAsDeflate = bl;
        this.ignoreEncryption = bl2;
        this.recoveryMode = bl3;
        if (seekableByteChannel.size() >= Integer.MAX_VALUE) {
            throw new IOException("Cannot handle archive greater than 2Gb");
        }
        this.archsize = (int)seekableByteChannel.size();
        if (this.archsize < 22) {
            throw new IOException("Illegal zip file: too small");
        }
        int n2 = -1;
        this.tmpPage = ByteBuffer.allocate(512).order(ByteOrder.LITTLE_ENDIAN);
        int n3 = this.archsize;
        while (n3 > 0) {
            n3 = Math.max(0, n3 - 509);
            seekableByteChannel.position(n3);
            this.tmpPage.clear();
            int n4 = seekableByteChannel.read(this.tmpPage);
            int n5 = ZipFailSafeReader.find(this.tmpPage.array(), n4, MAGIC_END_OF_CENTRALDIR);
            if (n5 < 0) continue;
            n2 = n3 + n5;
            break;
        }
        if (n2 < 0) {
            if (!bl3) {
                throw new IOException("The EOCD record was not found");
            }
            this.recoveryModeNoCD();
            return;
        }
        this.eocr = EndOfCentralDir.parse(seekableByteChannel, n2);
        if (this.eocr.diskNumber != 0 || this.eocr.cdDiskStartIndex != 0) {
            logger.info("Zip file: Ignoring multi-disk", new Object[0]);
        }
        this.offsetAppendedData = n2 + this.eocr.entrysize;
        if (!bl4) {
            ZipEntriesIterator zipEntriesIterator = new ZipEntriesIterator();
            while (zipEntriesIterator.hasNext()) {
                try {
                    zipEntriesIterator.next();
                }
                catch (RuntimeException runtimeException) {
                    Throwable throwable = runtimeException.getCause();
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    throw runtimeException;
                }
            }
        }
    }

    public Iterable<ZipEntry> enumerateEntries() {
        return new Iterable<ZipEntry>(){

            @Override
            public Iterator<ZipEntry> iterator() {
                return new ZipEntriesIterator();
            }
        };
    }

    private void recoveryModeNoCD() throws IOException {
        this.parsingComplete = false;
        this.offsetAppendedData = this.archsize;
        int n2 = 0;
        while (true) {
            LocalFileHeader localFileHeader;
            if ((n2 = this.findInFile(n2, MAGIC_LOCAL_FILEHDR)) < 0) {
                return;
            }
            try {
                localFileHeader = LocalFileHeader.parse(this.channel, n2);
            }
            catch (IOException iOException) {
                ++n2;
                continue;
            }
            if (this.entries.isEmpty()) {
                this.offsetFirstEntry = n2;
            }
            int n3 = n2 + localFileHeader.entrysize;
            (new Object[1])[0] = localFileHeader.getFilename();
            ZipEntry zipEntry = new ZipEntry(localFileHeader, null, n3);
            this.map.put(localFileHeader.getFilename(), zipEntry);
            this.entries.add(zipEntry);
            if (localFileHeader.hasDataDescriptor()) {
                int n4;
                if (localFileHeader.compressedSize != -1) {
                    n4 = n3 + localFileHeader.compressedSize;
                    if (n4 >= this.archsize) {
                        localFileHeader.corrupted = true;
                        break;
                    }
                    int n5 = ChannelUtil.getLEInt(this.channel, n4);
                    if (n5 == 134695760) {
                        n4 += 4;
                    }
                    localFileHeader.crc = ChannelUtil.getLEInt(this.channel, n4);
                    localFileHeader.compressedSize = ChannelUtil.getLEInt(this.channel, n4 + 4);
                    localFileHeader.filesize = ChannelUtil.getLEInt(this.channel, n4 + 8);
                    n2 = n4 + 12;
                } else {
                    n4 = this.findInFile(n3, MAGIC_DATA);
                    if (n4 < 0) {
                        n2 = n3;
                    } else {
                        if (n4 >= this.archsize) {
                            localFileHeader.corrupted = true;
                            break;
                        }
                        localFileHeader.crc = ChannelUtil.getLEInt(this.channel, n4 + 4);
                        localFileHeader.compressedSize = ChannelUtil.getLEInt(this.channel, n4 + 8);
                        localFileHeader.filesize = ChannelUtil.getLEInt(this.channel, n4 + 12);
                        n2 = n4 + 16;
                    }
                }
            } else {
                n2 = localFileHeader.compressedSize == -1 || localFileHeader.filesize == -1 ? n3 : n3 + localFileHeader.compressedSize;
            }
            if (n2 <= this.archsize) continue;
            localFileHeader.corrupted = true;
        }
        this.parsingComplete = true;
    }

    private int findInFile(int n2, byte[] byArray) throws IOException {
        while (n2 < this.archsize) {
            this.channel.position(n2);
            this.tmpPage.clear();
            int n3 = this.channel.read(this.tmpPage);
            int n4 = ZipFailSafeReader.find(this.tmpPage.array(), n3, byArray);
            if (n4 >= 0) {
                return n2 + n4;
            }
            n2 += 512 - byArray.length + 1;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public boolean isClosed() {
        return this.channel == null;
    }

    private void verifyFullyParsed() {
        if (this.parsingComplete == null || !this.parsingComplete.booleanValue()) {
            throw new IllegalStateException("Parsing of entries has not completed!");
        }
    }

    public int getOffsetFirstEntry() {
        this.verifyFullyParsed();
        return this.offsetFirstEntry;
    }

    public boolean hasPrependedData() {
        this.verifyFullyParsed();
        return this.offsetFirstEntry > 0;
    }

    public int getOffsetAppendedData() {
        this.verifyFullyParsed();
        return this.offsetAppendedData;
    }

    public boolean hasAppendedData() {
        this.verifyFullyParsed();
        return this.offsetAppendedData < this.archsize;
    }

    public boolean isTruncated() {
        this.verifyFullyParsed();
        return this.offsetAppendedData > this.archsize;
    }

    public int getNumberOfEntries() {
        this.verifyFullyParsed();
        return this.entries.size();
    }

    public List<ZipEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public ZipEntry getEntry(String string) {
        return this.map.get(string);
    }

    public boolean hasEntry(String string) {
        return this.map.containsKey(string);
    }

    public ZipData readData(String string) throws IOException {
        ZipEntry zipEntry = this.getEntry(string);
        if (zipEntry == null) {
            throw new IOException("Entry not found: " + string);
        }
        return this.readData(zipEntry);
    }

    public ZipData readData(ZipEntry zipEntry) throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("The archive is closed");
        }
        int n2 = zipEntry.getCompressedSize();
        if (n2 == 0) {
            return ZipData.EMPTY;
        }
        if (zipEntry.isEncrypted() && !this.ignoreEncryption) {
            throw new IOException("Entry is encrypted");
        }
        int n3 = zipEntry.getCompressionMethod();
        if (n3 != 0 && n3 != 8) {
            if (this.treatUnsupportedCompressionAsDeflate) {
                n3 = 0;
            } else {
                throw new IOException("Unsupported compression method: " + n3);
            }
        }
        ByteBuffer byteBuffer = this.recoveryMode ? ChannelUtil.readBestEffort(this.channel, zipEntry.getOffsetToData(), n2, false, null) : ChannelUtil.read(this.channel, zipEntry.getOffsetToData(), n2, false);
        byte[] byArray = null;
        int n4 = 0;
        try {
            Object object;
            if (n3 == 0) {
                byArray = byteBuffer.array();
                n4 = byArray.length;
            } else if (n3 == 8) {
                object = new Inflater(true);
                ((Inflater)object).setInput(byteBuffer.array(), 0, byteBuffer.limit());
                byArray = new byte[zipEntry.getFilesize()];
                try {
                    n4 = ((Inflater)object).inflate(byArray);
                }
                catch (DataFormatException dataFormatException) {
                    throw new IOException(dataFormatException);
                }
                ((Inflater)object).end();
            } else {
                throw new RuntimeException("Unsupported compression method: " + n3);
            }
            if (n4 != zipEntry.getFilesize()) {
                throw new IOException(Strings.ff("Corrupted entry: unexpected decompressed size: %d (expected %d)", n4, zipEntry.getFilesize()));
            }
            object = new CRC32();
            object.update(byArray);
            int n5 = (int)((CRC32)object).getValue();
            if (n5 != zipEntry.getCrc()) {
                throw new IOException(Strings.ff("Corrupted entry: unexpected CRC: %Xh (expected %Xh)", n5, zipEntry.getCrc()));
            }
        }
        catch (IOException iOException) {
            return new ZipData(byArray, n4, iOException);
        }
        return new ZipData(byArray, n4);
    }

    private static int find(byte[] byArray, int n2, byte[] byArray2) {
        block0: for (int i = 0; i <= n2 - byArray2.length; ++i) {
            if (byArray[i] != byArray2[0]) continue;
            int n3 = i + 1;
            for (int j = 1; n3 < n2 && j < byArray2.length; ++n3, ++j) {
                if (byArray[n3] != byArray2[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public String toString() {
        return Strings.ff("Zip archive: %d entries", this.getNumberOfEntries());
    }

    private class ZipEntriesIterator
    implements Iterator<ZipEntry> {
        int pos;
        int i;
        int cnt;

        ZipEntriesIterator() {
            if (ZipFailSafeReader.this.parsingComplete != null) {
                throw new IllegalStateException("An entries iterator had already been created (parsingComplete=" + ZipFailSafeReader.this.parsingComplete + ")");
            }
            ZipFailSafeReader.this.parsingComplete = false;
            this.pos = ZipFailSafeReader.this.eocr.cdOffset;
            this.cnt = Math.min(ZipFailSafeReader.this.eocr.cdRecordCountOnThisDisk, ZipFailSafeReader.this.eocr.cdRecordCountTotal);
        }

        @Override
        public boolean hasNext() {
            if (this.i < this.cnt) {
                return true;
            }
            ZipFailSafeReader.this.parsingComplete = true;
            return false;
        }

        @Override
        public ZipEntry next() {
            LocalFileHeader localFileHeader;
            CentralDirFileHeader centralDirFileHeader;
            int n2 = this.pos;
            try {
                centralDirFileHeader = CentralDirFileHeader.parse(ZipFailSafeReader.this.channel, this.pos);
            }
            catch (IOException iOException) {
                logger.error("Zip file discrepancy: invalid central-directory header", new Object[0]);
                throw new RuntimeException("Failed to read central directory file header at offset " + n2, iOException);
            }
            this.pos += centralDirFileHeader.entrysize;
            n2 = centralDirFileHeader.fileHeaderOffset;
            try {
                localFileHeader = LocalFileHeader.parse(ZipFailSafeReader.this.channel, centralDirFileHeader.fileHeaderOffset);
            }
            catch (IOException iOException) {
                logger.error("Zip file discrepancy: invalid local header", new Object[0]);
                throw new RuntimeException("Failed to read local file header at offset " + n2, iOException);
            }
            int n3 = centralDirFileHeader.fileHeaderOffset + localFileHeader.entrysize;
            ZipEntry zipEntry = new ZipEntry(localFileHeader, centralDirFileHeader, n3);
            ZipFailSafeReader.this.entries.add(zipEntry);
            ZipFailSafeReader.this.map.put(zipEntry.getFilenameUTF8(), zipEntry);
            if (!Arrays.equals(localFileHeader.filename, centralDirFileHeader.filename)) {
                String string = Strings.decodeUTF8(localFileHeader.filename);
                String string2 = Strings.decodeUTF8(centralDirFileHeader.filename);
                int n4 = Math.max(255, Math.min(string.length(), string2.length()));
                string = string.length() > n4 ? string.substring(0, n4 - 3) + "..." : string;
                string2 = string2.length() > n4 ? string2.substring(0, n4 - 3) + "..." : string2;
                logger.debug("Zip entry: name discrepancy: local_header=%s, center_header=%s", string, string2);
            }
            if (localFileHeader.flags != centralDirFileHeader.flags) {
                logger.debug("Zip entry: %s: flag discrepancy: local_header=0x%X, central_header=0x%X", zipEntry.getFilenameUTF8(), localFileHeader.flags, centralDirFileHeader.flags);
            }
            if (localFileHeader.compressionMethod == 0 && localFileHeader.compressedSize != localFileHeader.filesize) {
                logger.debug("Zip entry: %s: unexpected compressed size for STORED entry (file header): 0x%X (should be 0x%X)", zipEntry.getFilenameUTF8(), localFileHeader.compressedSize, localFileHeader.filesize);
            } else if (centralDirFileHeader.compressionMethod == 0 && centralDirFileHeader.compressedSize != centralDirFileHeader.filesize) {
                logger.debug("Zip entry: %s: unexpected compressed size for STORED entry (central dir. header): 0x%X (should be 0x%X)", zipEntry.getFilenameUTF8(), centralDirFileHeader.compressedSize, centralDirFileHeader.filesize);
            }
            if (centralDirFileHeader.fileHeaderOffset < ZipFailSafeReader.this.offsetFirstEntry) {
                ZipFailSafeReader.this.offsetFirstEntry = centralDirFileHeader.fileHeaderOffset;
            }
            ++this.i;
            return zipEntry;
        }
    }
}

