/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.encoding.zip.fsr.CentralDirFileHeader;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.LocalFileHeader;
import java.nio.charset.Charset;

public class ZipEntry {
    private LocalFileHeader hdr;
    private CentralDirFileHeader cdhdr;
    private int offsetToData;

    ZipEntry(LocalFileHeader localFileHeader, CentralDirFileHeader centralDirFileHeader, int n2) {
        this.hdr = localFileHeader;
        this.cdhdr = centralDirFileHeader;
        this.offsetToData = n2;
    }

    public boolean isHeaderCorrupted() {
        return this.hdr.corrupted || this.cdhdr != null && this.cdhdr.corrupted;
    }

    public String getFilenameUTF8() {
        return this.getFilename(Charset.forName("UTF-8"));
    }

    public String getFilename(Charset charset) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        if (this.cdhdr != null) {
            return new String(this.cdhdr.filename, charset);
        }
        return new String(this.hdr.filename, charset);
    }

    public int getFilesize() {
        if (this.cdhdr != null) {
            return this.cdhdr.filesize;
        }
        return this.hdr.filesize;
    }

    public int getCompressedSize() {
        int n2 = this.getCompressionMethod();
        if (n2 == 0) {
            return this.getFilesize();
        }
        if (this.cdhdr != null && this.cdhdr.compressedSize >= 0) {
            return this.cdhdr.compressedSize;
        }
        return this.hdr.compressedSize;
    }

    public boolean isEncrypted() {
        if (this.cdhdr != null) {
            return this.cdhdr.isEncrypted() && this.hdr.isEncrypted();
        }
        return this.hdr.isEncrypted();
    }

    private static boolean heurLooksLikeValidCompressionMethod(int n2) {
        return n2 >= 0 && n2 <= 20 || n2 >= 93 && n2 <= 99;
    }

    public int getCompressionMethod() {
        if (this.cdhdr != null) {
            if (!ZipEntry.heurLooksLikeValidCompressionMethod(this.cdhdr.compressionMethod)) {
                return 0;
            }
            return this.cdhdr.compressionMethod;
        }
        if (!ZipEntry.heurLooksLikeValidCompressionMethod(this.hdr.compressionMethod)) {
            return 0;
        }
        return this.hdr.compressionMethod;
    }

    public int getCrc() {
        if (this.cdhdr != null) {
            return this.cdhdr.crc;
        }
        return this.hdr.crc;
    }

    public boolean isDirectory() {
        if (this.cdhdr != null) {
            if (this.cdhdr.filename.length == 0) {
                return false;
            }
            return this.cdhdr.filename[this.cdhdr.filename.length - 1] == 47;
        }
        if (this.hdr.filename.length == 0) {
            return false;
        }
        return this.hdr.filename[this.hdr.filename.length - 1] == 47;
    }

    public int getOffsetToData() {
        return this.offsetToData;
    }

    public String toString() {
        return this.getFilenameUTF8();
    }
}

