/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;

public class LocalFileHeader {
    int versionRequired;
    int flags;
    int compressionMethod;
    int modTime;
    int modDate;
    int crc;
    int compressedSize;
    int filesize;
    byte[] filename = ArrayUtil.NO_BYTE;
    byte[] extra = ArrayUtil.NO_BYTE;
    int entrysize;
    boolean corrupted;

    public static LocalFileHeader parse(SeekableByteChannel seekableByteChannel, int n2) throws IOException {
        LocalFileHeader localFileHeader = new LocalFileHeader();
        try {
            ByteBuffer byteBuffer;
            localFileHeader.versionRequired = ChannelUtil.getLEShort(seekableByteChannel, n2 + 4) & 0xFFFF;
            localFileHeader.flags = ChannelUtil.getLEShort(seekableByteChannel, n2 + 6) & 0xFFFF;
            localFileHeader.compressionMethod = ChannelUtil.getLEShort(seekableByteChannel, n2 + 8) & 0xFFFF;
            localFileHeader.modTime = ChannelUtil.getLEShort(seekableByteChannel, n2 + 10) & 0xFFFF;
            localFileHeader.modDate = ChannelUtil.getLEShort(seekableByteChannel, n2 + 12) & 0xFFFF;
            localFileHeader.crc = ChannelUtil.getLEInt(seekableByteChannel, n2 + 14);
            localFileHeader.compressedSize = ChannelUtil.getLEInt(seekableByteChannel, n2 + 18);
            localFileHeader.filesize = ChannelUtil.getLEInt(seekableByteChannel, n2 + 22);
            int n3 = ChannelUtil.getLEShort(seekableByteChannel, n2 + 26) & 0xFFFF;
            int n4 = ChannelUtil.getLEShort(seekableByteChannel, n2 + 28) & 0xFFFF;
            if (n3 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(seekableByteChannel, n2 + 30, n3, false, null);
                if (byteBuffer.limit() != n3) {
                    localFileHeader.corrupted = true;
                }
                localFileHeader.filename = byteBuffer.array();
            }
            if (n4 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(seekableByteChannel, n2 + 30 + n3, n4, false, null);
                if (byteBuffer.limit() != n4) {
                    localFileHeader.corrupted = true;
                }
                localFileHeader.extra = byteBuffer.array();
            }
            localFileHeader.entrysize = 30 + n3 + n4;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException);
        }
        return localFileHeader;
    }

    public String getFilename() {
        return new String(this.filename, Charset.forName("UTF-8"));
    }

    public boolean isEncrypted() {
        return (this.flags & 1) != 0;
    }

    public boolean hasDataDescriptor() {
        return (this.flags & 8) != 0;
    }

    public String toString() {
        return Strings.ff("%s:%d(%d)%s", this.getFilename(), this.filesize, this.compressionMethod, this.corrupted ? "[BAD!]" : "");
    }
}

