/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class EndOfCentralDir {
    int diskNumber;
    int cdDiskStartIndex;
    int cdRecordCountOnThisDisk;
    int cdRecordCountTotal;
    int cdSize;
    int cdOffset;
    byte[] comment = ArrayUtil.NO_BYTE;
    int entrysize;
    boolean corrupted;

    public static EndOfCentralDir parse(SeekableByteChannel seekableByteChannel, int n2) throws IOException {
        EndOfCentralDir endOfCentralDir = new EndOfCentralDir();
        try {
            endOfCentralDir.diskNumber = ChannelUtil.getLEShort(seekableByteChannel, n2 + 4) & 0xFFFF;
            endOfCentralDir.cdDiskStartIndex = ChannelUtil.getLEShort(seekableByteChannel, n2 + 6) & 0xFFFF;
            endOfCentralDir.cdRecordCountOnThisDisk = ChannelUtil.getLEShort(seekableByteChannel, n2 + 8) & 0xFFFF;
            endOfCentralDir.cdRecordCountTotal = ChannelUtil.getLEShort(seekableByteChannel, n2 + 10) & 0xFFFF;
            endOfCentralDir.cdSize = ChannelUtil.getLEInt(seekableByteChannel, n2 + 12);
            endOfCentralDir.cdOffset = ChannelUtil.getLEInt(seekableByteChannel, n2 + 16);
            int n3 = ChannelUtil.getLEShort(seekableByteChannel, n2 + 20) & 0xFFFF;
            if (n3 > 0) {
                ByteBuffer byteBuffer = ChannelUtil.readBestEffort(seekableByteChannel, n2 + 22, n3, false, null);
                if (byteBuffer.limit() != n3) {
                    endOfCentralDir.corrupted = true;
                }
                endOfCentralDir.comment = byteBuffer.array();
            }
            endOfCentralDir.entrysize = 22 + n3;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException);
        }
        return endOfCentralDir;
    }

    public String toString() {
        return Strings.ff("%d/%d/offset=%Xh,size=%Xh,entries=%d/%d%s", this.diskNumber, this.cdDiskStartIndex, this.cdOffset, this.cdSize, this.cdRecordCountOnThisDisk, this.cdRecordCountTotal, this.corrupted ? "[BAD!]" : "");
    }
}

