/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;

public class CentralDirFileHeader {
    int versionCreated;
    int versionRequired;
    int flags;
    int compressionMethod;
    int modTime;
    int modDate;
    int crc;
    int compressedSize;
    int filesize;
    byte[] filename = ArrayUtil.NO_BYTE;
    byte[] extra = ArrayUtil.NO_BYTE;
    byte[] comment = ArrayUtil.NO_BYTE;
    int diskNumber;
    int internalFileAttr;
    int externalFileAttr;
    int fileHeaderOffset;
    int entrysize;
    boolean corrupted;

    public static CentralDirFileHeader parse(SeekableByteChannel seekableByteChannel, int n2) throws IOException {
        CentralDirFileHeader centralDirFileHeader = new CentralDirFileHeader();
        try {
            ByteBuffer byteBuffer;
            centralDirFileHeader.versionCreated = ChannelUtil.getLEShort(seekableByteChannel, n2 + 4) & 0xFFFF;
            centralDirFileHeader.versionRequired = ChannelUtil.getLEShort(seekableByteChannel, n2 + 6) & 0xFFFF;
            centralDirFileHeader.flags = ChannelUtil.getLEShort(seekableByteChannel, n2 + 8) & 0xFFFF;
            centralDirFileHeader.compressionMethod = ChannelUtil.getLEShort(seekableByteChannel, n2 + 10) & 0xFFFF;
            centralDirFileHeader.modTime = ChannelUtil.getLEShort(seekableByteChannel, n2 + 12) & 0xFFFF;
            centralDirFileHeader.modDate = ChannelUtil.getLEShort(seekableByteChannel, n2 + 14) & 0xFFFF;
            centralDirFileHeader.crc = ChannelUtil.getLEInt(seekableByteChannel, n2 + 16);
            centralDirFileHeader.compressedSize = ChannelUtil.getLEInt(seekableByteChannel, n2 + 20);
            centralDirFileHeader.filesize = ChannelUtil.getLEInt(seekableByteChannel, n2 + 24);
            int n3 = ChannelUtil.getLEShort(seekableByteChannel, n2 + 28) & 0xFFFF;
            int n4 = ChannelUtil.getLEShort(seekableByteChannel, n2 + 30) & 0xFFFF;
            int n5 = ChannelUtil.getLEShort(seekableByteChannel, n2 + 32) & 0xFFFF;
            centralDirFileHeader.diskNumber = ChannelUtil.getLEShort(seekableByteChannel, n2 + 34) & 0xFFFF;
            centralDirFileHeader.internalFileAttr = ChannelUtil.getLEShort(seekableByteChannel, n2 + 36) & 0xFFFF;
            centralDirFileHeader.externalFileAttr = ChannelUtil.getLEInt(seekableByteChannel, n2 + 38);
            centralDirFileHeader.fileHeaderOffset = ChannelUtil.getLEInt(seekableByteChannel, n2 + 42);
            if (n3 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(seekableByteChannel, n2 + 46, n3, false, null);
                if (byteBuffer.limit() != n3) {
                    centralDirFileHeader.corrupted = true;
                }
                centralDirFileHeader.filename = byteBuffer.array();
            }
            if (n4 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(seekableByteChannel, n2 + 46 + n3, n4, false, null);
                if (byteBuffer.limit() != n4) {
                    centralDirFileHeader.corrupted = true;
                }
                centralDirFileHeader.extra = byteBuffer.array();
            }
            if (n5 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(seekableByteChannel, n2 + 46 + n3 + n4, n5, false, null);
                if (byteBuffer.limit() != n5) {
                    centralDirFileHeader.corrupted = true;
                }
                centralDirFileHeader.extra = byteBuffer.array();
            }
            centralDirFileHeader.entrysize = 46 + n3 + n4 + n5;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException);
        }
        return centralDirFileHeader;
    }

    public String getFilename() {
        return new String(this.filename, Charset.forName("UTF-8"));
    }

    public boolean isEncrypted() {
        return (this.flags & 1) != 0;
    }

    public String toString() {
        return Strings.ff("%s:%d(%d)%s", this.getFilename(), this.filesize, this.compressionMethod, this.corrupted ? "[BAD!]" : "");
    }
}

