/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip;

import com.pnfsoftware.jeb.util.encoding.zip.GenericZipEntry;
import com.pnfsoftware.jeb.util.encoding.zip.IGenericZipBrowser;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.ZipData;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.ZipEntry;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.ZipFailSafeReader;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class ZipBrowserPNF
implements IGenericZipBrowser {
    private static final ILogger logger = GlobalLog.getLogger(ZipBrowserPNF.class);
    private ZipFailSafeReader zip;
    private LinkedHashMap<String, GenericZipEntry<java.util.zip.ZipEntry>> entries = new LinkedHashMap();

    public ZipBrowserPNF(File file, boolean bl, boolean bl2) throws IOException {
        this.zip = new ZipFailSafeReader(file, bl, bl2, false, false);
        this.parseEntries();
    }

    private void parseEntries() {
        for (ZipEntry zipEntry : this.zip.getEntries()) {
            java.util.zip.ZipEntry zipEntry2 = new java.util.zip.ZipEntry(zipEntry.getFilenameUTF8());
            zipEntry2.setSize(zipEntry.getFilesize());
            zipEntry2.setCompressedSize(zipEntry.getCompressedSize());
            this.entries.put(zipEntry2.getName(), new GenericZipEntry<java.util.zip.ZipEntry>(zipEntry2));
        }
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    @Override
    public Map<String, GenericZipEntry<?>> getEntries() {
        return this.entries;
    }

    @Override
    public GenericZipEntry<?> getEntry(String string) {
        return this.entries.get(string);
    }

    @Override
    public byte[] readEntry(String string) throws IOException {
        GenericZipEntry<java.util.zip.ZipEntry> genericZipEntry = this.entries.get(string);
        if (genericZipEntry == null) {
            throw new IOException(Strings.ff("Entry %s is not a valid file entry", string));
        }
        ZipData zipData = this.zip.readData(string);
        if (zipData.getException() != null) {
            logger.error("Entry: %s: ERROR: %s", string, zipData.getException());
        }
        return zipData.getUncompressedData();
    }

    @Override
    public InputStream getEntryStream(String string) throws IOException {
        return new ByteArrayInputStream(this.readEntry(string));
    }
}

