/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip;

import com.pnfsoftware.jeb.util.encoding.zip.GenericZipEntry;
import com.pnfsoftware.jeb.util.encoding.zip.IGenericZipBrowser;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipBrowserOracle
implements IGenericZipBrowser {
    public static final String[] csnamesTrylist = new String[]{"UTF-8", "ISO-8859-1"};
    private ZipFile zip;
    private LinkedHashMap<String, GenericZipEntry<ZipEntry>> entries = new LinkedHashMap();

    public ZipBrowserOracle(File file) throws IOException {
        for (String string : csnamesTrylist) {
            Charset charset = Charset.forName(string);
            try {
                this.zip = new ZipFile(file, 1, charset);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("MALFORMED".equals(illegalArgumentException.getMessage())) continue;
                throw illegalArgumentException;
            }
        }
        this.parseEntries();
    }

    public ZipBrowserOracle(File file, Charset charset) throws IOException {
        this.zip = new ZipFile(file, 1, charset);
    }

    private void parseEntries() {
        Enumeration<? extends ZipEntry> enumeration = this.zip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            this.entries.put(zipEntry.getName(), new GenericZipEntry<ZipEntry>(zipEntry));
        }
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    @Override
    public Map<String, GenericZipEntry<?>> getEntries() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string : this.entries.keySet()) {
            linkedHashMap.put(string, this.entries.get(string));
        }
        return linkedHashMap;
    }

    @Override
    public GenericZipEntry<?> getEntry(String string) {
        return this.entries.get(string);
    }

    @Override
    public byte[] readEntry(String string) throws IOException {
        GenericZipEntry<ZipEntry> genericZipEntry = this.entries.get(string);
        if (genericZipEntry == null || genericZipEntry.isDirectory()) {
            throw new IOException(Strings.ff("Entry %s is not a valid file entry", string));
        }
        try (InputStream inputStream = this.zip.getInputStream(genericZipEntry.getInternalEntry());){
            byte[] byArray = IO.readInputStream(inputStream);
            return byArray;
        }
    }

    @Override
    public InputStream getEntryStream(String string) throws IOException {
        GenericZipEntry<ZipEntry> genericZipEntry = this.entries.get(string);
        if (genericZipEntry == null || genericZipEntry.isDirectory()) {
            throw new IOException(Strings.ff("Entry %s is not a valid file entry", string));
        }
        return this.zip.getInputStream(genericZipEntry.getInternalEntry());
    }
}

