/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip;

import com.pnfsoftware.jeb.util.encoding.zip.GenericZipEntry;
import com.pnfsoftware.jeb.util.encoding.zip.IGenericZipBrowser;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipBrowserApache
implements IGenericZipBrowser {
    private ZipFile zip;
    private LinkedHashMap<String, GenericZipEntry<ZipArchiveEntry>> entries = new LinkedHashMap();

    public ZipBrowserApache(File file) throws IOException {
        this.zip = new ZipFile(file);
        this.parseEntries();
    }

    private void parseEntries() {
        Enumeration enumeration = this.zip.getEntries();
        while (enumeration.hasMoreElements()) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)enumeration.nextElement();
            this.entries.put(zipArchiveEntry.getName(), new GenericZipEntry<ZipArchiveEntry>(zipArchiveEntry));
        }
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    @Override
    public Map<String, GenericZipEntry<?>> getEntries() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string : this.entries.keySet()) {
            linkedHashMap.put(string, this.entries.get(string));
        }
        return linkedHashMap;
    }

    @Override
    public GenericZipEntry<?> getEntry(String string) {
        return this.entries.get(string);
    }

    @Override
    public byte[] readEntry(String string) throws IOException {
        GenericZipEntry<ZipArchiveEntry> genericZipEntry = this.entries.get(string);
        if (genericZipEntry == null || genericZipEntry.isDirectory()) {
            throw new IOException(Strings.ff("Entry %s is not a valid file entry", string));
        }
        try (InputStream inputStream = this.zip.getInputStream(genericZipEntry.getInternalEntry());){
            byte[] byArray = IO.readInputStream(inputStream);
            return byArray;
        }
    }

    @Override
    public InputStream getEntryStream(String string) throws IOException {
        GenericZipEntry<ZipArchiveEntry> genericZipEntry = this.entries.get(string);
        if (genericZipEntry == null || genericZipEntry.isDirectory()) {
            throw new IOException(Strings.ff("Entry %s is not a valid file entry", string));
        }
        return this.zip.getInputStream(genericZipEntry.getInternalEntry());
    }
}

