/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip;

import com.pnfsoftware.jeb.util.encoding.zip.GenericZipEntry;
import com.pnfsoftware.jeb.util.encoding.zip.IGenericJarBrowser;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarBrowserOracle
implements IGenericJarBrowser {
    private JarFile jar;
    private LinkedHashMap<String, GenericZipEntry<JarEntry>> entries = new LinkedHashMap();

    public JarBrowserOracle(File file, boolean bl) throws IOException {
        this.jar = new JarFile(file, bl);
        this.parseEntries();
    }

    private void parseEntries() {
        Enumeration<JarEntry> enumeration = this.jar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            this.entries.put(jarEntry.getName(), new GenericZipEntry<JarEntry>(jarEntry));
        }
    }

    @Override
    public void close() throws IOException {
        this.jar.close();
    }

    @Override
    public Map<String, GenericZipEntry<?>> getEntries() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string : this.entries.keySet()) {
            linkedHashMap.put(string, this.entries.get(string));
        }
        return linkedHashMap;
    }

    @Override
    public GenericZipEntry<?> getEntry(String string) {
        return this.entries.get(string);
    }

    @Override
    public byte[] readEntry(String string) throws IOException {
        byte[] byArray;
        block10: {
            GenericZipEntry<JarEntry> genericZipEntry = this.entries.get(string);
            if (genericZipEntry == null || genericZipEntry.isDirectory()) {
                throw new IOException(Strings.ff("Entry %s is not a valid file entry", string));
            }
            InputStream inputStream = this.jar.getInputStream(genericZipEntry.getInternalEntry());
            try {
                byte[] byArray2 = IO.readInputStream(inputStream);
                if ((long)byArray2.length != genericZipEntry.getSize()) {
                    throw new IOException();
                }
                byArray = byArray2;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    @Override
    public InputStream getEntryStream(String string) throws IOException {
        GenericZipEntry<JarEntry> genericZipEntry = this.entries.get(string);
        if (genericZipEntry == null || genericZipEntry.isDirectory()) {
            return null;
        }
        return this.jar.getInputStream(genericZipEntry.getInternalEntry());
    }

    @Override
    public Certificate[] getCertificates(String string) {
        Certificate[] certificateArray;
        block10: {
            GenericZipEntry<JarEntry> genericZipEntry = this.entries.get(string);
            if (genericZipEntry == null || genericZipEntry.isDirectory()) {
                return null;
            }
            InputStream inputStream = this.jar.getInputStream(genericZipEntry.getInternalEntry());
            try {
                byte[] byArray = IO.readInputStream(inputStream);
                if ((long)byArray.length != genericZipEntry.getSize()) {
                    throw new IOException("Unexpected decompressed size");
                }
                certificateArray = genericZipEntry.getInternalEntry().getCertificates();
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            inputStream.close();
        }
        return certificateArray;
    }
}

