/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.xml;

import com.pnfsoftware.jeb.util.base.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static boolean isSpace(int n2) {
        return n2 == 32 || n2 == 9 || n2 == 13 || n2 == 10 || Character.isSpaceChar(n2);
    }

    public static int skipSomeSpaces(String string, int n2) {
        return XmlUtil.skipWSP(string, n2, 1);
    }

    public static int skipSpaces(String string, int n2) {
        return XmlUtil.skipWSP(string, n2, 0);
    }

    public static int skipWSP(String string, int n2, int n3) {
        int n4;
        int n5 = 0;
        while (n2 < string.length() && XmlUtil.isSpace(n4 = string.codePointAt(n2))) {
            n2 += Character.charCount(n4);
            ++n5;
        }
        Assert.a(n5 >= n3, "Expected more spaces");
        return n2;
    }

    public static int readToken(String string, int n2, Collection<Integer> collection, String[] stringArray) {
        return XmlUtil.readToken(string, n2, collection, stringArray, false, false);
    }

    public static int readToken(String string, int n2, Collection<Integer> collection, String[] stringArray, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = -1;
        while (true) {
            int n4;
            int n5 = string.codePointAt(n2);
            n2 += Character.charCount(n5);
            if (n3 == -1) {
                if (n5 == 39 || n5 == 34) {
                    n3 = n5;
                    continue;
                }
                n3 = 0;
                Assert.a(!bl, "Expected no quote");
            }
            if (n3 == 0) {
                if (XmlUtil.isSpace(n5) || collection != null && collection.contains(n5)) {
                    n2 -= Character.charCount(n5);
                    break;
                }
                stringBuilder.appendCodePoint(n5);
                continue;
            }
            if (n5 == n3) break;
            if (n5 == 92 && bl2) {
                n4 = string.codePointAt(n2);
                n2 += Character.charCount(n4);
                if (n4 == 110) {
                    stringBuilder.append('\n');
                    continue;
                }
                if (n4 == 116) {
                    stringBuilder.append('\t');
                    continue;
                }
                stringBuilder.appendCodePoint(n4);
                continue;
            }
            if (n5 == 38) {
                n4 = -1;
                int n6 = n2;
                StringBuilder stringBuilder2 = new StringBuilder();
                while (n2 < string.length() && (n4 = string.codePointAt(n2)) != 92 && n4 != n3) {
                    n2 += Character.charCount(n4);
                    if (n4 == 59) break;
                    stringBuilder2.appendCodePoint(n4);
                }
                String string2 = stringBuilder2.toString();
                if (n4 == 59) {
                    if (string2.equals("lt")) {
                        stringBuilder.append('<');
                        continue;
                    }
                    if (string2.equals("gt")) {
                        stringBuilder.append('>');
                        continue;
                    }
                    if (string2.equals("amp")) {
                        stringBuilder.append('&');
                        continue;
                    }
                    if (string2.equals("apos")) {
                        stringBuilder.append('\'');
                        continue;
                    }
                    if (string2.equals("quot")) {
                        stringBuilder.append('\"');
                        continue;
                    }
                    if (string2.charAt(0) == '#') {
                        try {
                            char c2 = string2.charAt(1);
                            int n7 = c2 == 'x' ? Integer.parseInt(string2.substring(2), 16) : Integer.parseInt(string2.substring(1), 10);
                            stringBuilder.appendCodePoint(n7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            stringBuilder.append('&');
                            n2 = n6;
                        }
                        continue;
                    }
                    stringBuilder.append('&');
                    stringBuilder.append((CharSequence)stringBuilder2);
                    stringBuilder.append(';');
                    continue;
                }
                stringBuilder.append('&');
                stringBuilder.append((CharSequence)stringBuilder2);
                continue;
            }
            stringBuilder.appendCodePoint(n5);
        }
        Assert.a(n3 > 0 || stringBuilder.length() >= 1, "Expected quoted token or empty token");
        if (stringArray != null) {
            stringArray[0] = stringBuilder.toString();
        }
        return n2;
    }

    public static boolean compare(String string, int n2, String string2) {
        int n3 = string2.length();
        if (n2 + n3 > string.length()) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (string.charAt(n2 + i) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareCI(String string, int n2, String string2) {
        int n3 = string2.length();
        if (n2 + n3 > string.length()) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (Character.toLowerCase(string.charAt(n2 + i)) == Character.toLowerCase(string2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Element getFirstChildElement(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !string.equals(((Element)node).getTagName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static List<Element> getChildrenElements(Element element, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !string.equals(((Element)node).getTagName())) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    public static String format(Document document) {
        return document.toString();
    }
}

