/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.xml;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.encoding.xml.XAttr;
import com.pnfsoftware.jeb.util.encoding.xml.XCDATASection;
import com.pnfsoftware.jeb.util.encoding.xml.XComment;
import com.pnfsoftware.jeb.util.encoding.xml.XDocument;
import com.pnfsoftware.jeb.util.encoding.xml.XDocumentType;
import com.pnfsoftware.jeb.util.encoding.xml.XElement;
import com.pnfsoftware.jeb.util.encoding.xml.XNode;
import com.pnfsoftware.jeb.util.encoding.xml.XText;
import com.pnfsoftware.jeb.util.encoding.xml.XmlUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

public class XmlParser {
    private static final ILogger logger = GlobalLog.getLogger(XmlParser.class);
    private final List<Integer> attributeNameSeparator = Arrays.asList(61);
    private final List<Integer> elementEnd = Arrays.asList(62, 47);
    private boolean assignParentNodes;
    private boolean sortAttributes;
    private boolean handleBackslashAxmlStyle;
    private boolean allowUnclosedTags;
    private boolean allowMismatchedTags;
    private String str;
    private int idx;
    private boolean declProcessed;
    private int lastEltClose;
    private Deque<String> openedEltStack;

    private static final void log(String string, Object ... objectArray) {
    }

    public void setAssignParentNodes(boolean bl) {
        this.assignParentNodes = bl;
    }

    public boolean isAssignParentNodes() {
        return this.assignParentNodes;
    }

    public void setSortAttributes(boolean bl) {
        this.sortAttributes = bl;
    }

    public boolean isSortAttributes() {
        return this.sortAttributes;
    }

    public void setHandleBackslashAxmlStyle(boolean bl) {
        this.handleBackslashAxmlStyle = bl;
    }

    public boolean isHandleBackslashAxmlStyle() {
        return this.handleBackslashAxmlStyle;
    }

    public void setAllowUnclosedTags(boolean bl) {
        this.allowUnclosedTags = bl;
    }

    public boolean isAllowUnclosedTags() {
        return this.allowUnclosedTags;
    }

    public void setAllowMismatchedTags(boolean bl) {
        this.allowMismatchedTags = bl;
    }

    public boolean isAllowMismatchedTags() {
        return this.allowMismatchedTags;
    }

    private void reset(String string) {
        this.str = string;
        this.idx = 0;
        this.declProcessed = false;
        this.lastEltClose = 0;
        this.openedEltStack = new ArrayDeque<String>();
    }

    public XDocument parse(String string) throws ParseException {
        this.reset(string);
        return this.parseInternal(string);
    }

    public XDocument parse(byte[] byArray) throws ParseException {
        this.reset(null);
        int n2 = ArrayUtil.find(byArray, (byte)62);
        Assert.a(n2 >= 0, "Cannot find end of xml header");
        this.str = new String(byArray, 0, n2 + 1, Charset.forName("ascii"));
        this.skipSpaces();
        Assert.a(this.cmpskip("<?xml"), "Expected xml marker");
        this.skipSomeSpaces();
        List<XAttr> list = this.readAttributes();
        XAttr xAttr = (XAttr)this.findNodeByName(list, "version");
        String string = xAttr.getValue();
        Assert.a(string.startsWith("1."), "Expected 1.x version number");
        String string2 = "utf8";
        xAttr = (XAttr)this.findNodeByName(list, "encoding");
        if (xAttr != null) {
            string2 = xAttr.getValue();
        }
        String string3 = new String(byArray, Charset.forName(string2));
        this.reset(string3);
        return this.parseInternal(string3);
    }

    private XDocument parseInternal(String string) {
        Object object;
        this.skipSpaces();
        Assert.a(this.cmpskip("<?xml"), "Expected xml marker");
        this.skipSomeSpaces();
        List<XAttr> list = this.readAttributes();
        XAttr xAttr = (XAttr)this.findNodeByName(list, "version");
        String string2 = xAttr.getValue();
        Assert.a(string2.startsWith("1."), "Expected 1.x version number");
        this.declProcessed = true;
        XDocumentType xDocumentType = null;
        this.skipSpaces();
        ArrayList<XNode> arrayList = new ArrayList<XNode>();
        while (this.idx < string.length() - 1 && string.charAt(this.idx) == '<') {
            if (this.cmpskip("<!--")) {
                object = this.readUntil("-->");
                arrayList.add(new XComment((String)object));
            } else if (this.cmpskip("<?xml-")) {
                this.readUntil("?>");
            } else if (this.cmpskip("<!DOCTYPE")) {
                this.skipSomeSpaces();
                object = this.readToken(null, false);
                this.skipSomeSpaces();
                if (this.cmpnoskip("[")) {
                    this.readUntil("]>");
                } else {
                    this.readUntil(">");
                }
                xDocumentType = new XDocumentType((String)object, null, null);
                arrayList.add(xDocumentType);
            } else {
                arrayList.add(this.readElement());
            }
            this.skipSpaces();
        }
        Assert.a(this.openedEltStack.isEmpty(), "Expected empty element stack");
        this.skipSpaces();
        Assert.a(this.idx == string.length(), "Expected no appended data");
        object = new XDocument(list, xDocumentType);
        ((XNode)object).initChildren(arrayList);
        if (this.assignParentNodes) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(object);
            while (!arrayList2.isEmpty()) {
                XNode xNode = (XNode)arrayList2.remove(0);
                for (XNode xNode2 : xNode.children.list) {
                    xNode2.parent = xNode;
                }
                if (xNode instanceof XElement) {
                    for (XNode xNode3 : ((XElement)xNode).attrmap.list) {
                        ((XAttr)xNode3).owner = (XElement)xNode;
                    }
                }
                arrayList2.addAll(xNode.children.list);
            }
        }
        return object;
    }

    private int readCp() {
        Assert.a(this.idx < this.str.length(), "Expected more characters");
        int n2 = this.str.codePointAt(this.idx);
        this.idx += Character.charCount(n2);
        return n2;
    }

    private void skipSpaces() {
        this.idx = XmlUtil.skipSpaces(this.str, this.idx);
    }

    private void skipSomeSpaces() {
        this.idx = XmlUtil.skipSomeSpaces(this.str, this.idx);
    }

    private String readToken(Collection<Integer> collection, boolean bl) {
        String[] stringArray = new String[1];
        this.idx = XmlUtil.readToken(this.str, this.idx, collection, stringArray, bl, this.handleBackslashAxmlStyle);
        return stringArray[0];
    }

    private XElement readElement() {
        int n2 = this.readCp();
        Assert.a(n2 == 60, "Expected opening angle bracket");
        String string = this.readToken(this.elementEnd, false);
        if (this.declProcessed && string.equals("?xml")) {
            throw new RuntimeException("Multiple xml declarators detected");
        }
        XElement xElement = new XElement(string);
        this.openedEltStack.push(string);
        XmlParser.log("Elt: %s", string);
        this.skipSpaces();
        xElement.initAttributes(this.readAttributes());
        if (this.lastEltClose == 1) {
            int n3 = this.idx;
            try {
                this.readInner(xElement);
            }
            catch (RuntimeException runtimeException) {
                if (this.allowUnclosedTags && this.cmpskip("</" + string)) {
                    this.idx = n3;
                    String string2 = this.readUntil("</" + string, false);
                    ArrayList<XNode> arrayList = new ArrayList<XNode>();
                    arrayList.add(new XText(string2));
                    xElement.initChildren(arrayList);
                    while (!this.openedEltStack.isEmpty() && !this.openedEltStack.getFirst().equals(string)) {
                        this.openedEltStack.pop();
                    }
                    if (this.openedEltStack.isEmpty()) {
                        throw runtimeException;
                    }
                }
                throw runtimeException;
            }
            this.skipSpaces();
            Assert.a(this.cmpskip("</" + string, this.allowMismatchedTags), "Expected matching closing element");
            this.skipSpaces();
            Assert.a(this.cmpskip(">"), "Expected closing angle bracket");
        } else {
            Assert.a(this.lastEltClose == 2, "Expected self-closing element");
        }
        this.openedEltStack.pop();
        return xElement;
    }

    private void readInner(XElement xElement) {
        ArrayList<XNode> arrayList = new ArrayList<XNode>();
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            String string;
            int n2;
            if ((n2 = this.readCp()) != 60) {
                stringBuilder.appendCodePoint(n2);
                continue;
            }
            if (stringBuilder.length() > 0) {
                arrayList.add(new XText(stringBuilder.toString()));
                stringBuilder.setLength(0);
            }
            --this.idx;
            if (this.cmpskip("<!--")) {
                string = this.readUntil("-->");
                arrayList.add(new XComment(string));
                continue;
            }
            if (this.cmpskip("<![CDATA[")) {
                string = this.readUntil("]]>");
                arrayList.add(new XCDATASection(string));
                continue;
            }
            if (this.cmpnoskip("</")) break;
            arrayList.add(this.readElement());
        }
        xElement.initChildren(arrayList);
    }

    private String readUntil(String string) {
        return this.readUntil(string, true);
    }

    private String readUntil(String string, boolean bl) {
        int n2 = this.str.indexOf(string, this.idx);
        String string2 = this.str.substring(this.idx, n2);
        this.idx = bl ? n2 + string.length() : n2;
        return string2;
    }

    private List<XAttr> readAttributes() {
        ArrayList<XAttr> arrayList = new ArrayList<XAttr>();
        while (true) {
            this.skipSpaces();
            if (this.cmpskip(">")) {
                this.lastEltClose = 1;
                break;
            }
            if (this.cmpskip("/>")) {
                this.lastEltClose = 2;
                break;
            }
            if (this.cmpskip("?>")) {
                Assert.a(!this.declProcessed, "Expected unprocessed xml declarator");
                this.lastEltClose = 3;
                break;
            }
            XAttr xAttr3 = this.readAttribute();
            XmlParser.log("  Attr: %s", xAttr3);
            arrayList.add(xAttr3);
        }
        if (this.sortAttributes) {
            arrayList.sort((xAttr, xAttr2) -> xAttr.name.compareTo(xAttr2.name));
        }
        return arrayList;
    }

    private XAttr readAttribute() {
        String string = this.readToken(this.attributeNameSeparator, false);
        this.skipSpaces();
        Assert.a(this.readCp() == 61, "Expected equal character");
        this.skipSpaces();
        String string2 = this.readToken(this.elementEnd, false);
        return new XAttr(string, string2);
    }

    private boolean cmpskip(String string) {
        return this.cmp(string, true, false);
    }

    private boolean cmpnoskip(String string) {
        return this.cmp(string, false, false);
    }

    private boolean cmpskip(String string, boolean bl) {
        return this.cmp(string, true, bl);
    }

    private boolean cmpnoskip(String string, boolean bl) {
        return this.cmp(string, false, bl);
    }

    private boolean cmp(String string, boolean bl, boolean bl2) {
        int n2 = string.length();
        if (this.idx + n2 > this.str.length()) {
            return false;
        }
        if (!bl2) {
            for (int i = 0; i < n2; ++i) {
                if (this.str.charAt(this.idx + i) == string.charAt(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (Character.toLowerCase(this.str.charAt(this.idx + i)) == Character.toLowerCase(string.charAt(i))) continue;
                return false;
            }
        }
        if (bl) {
            this.idx += n2;
        }
        return true;
    }

    XNode findNodeByName(Collection<? extends XNode> collection, String string) {
        Optional<XNode> optional = collection.stream().filter(xNode -> xNode.getNodeName().equals(string)).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }
}

