/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.xml;

import com.pnfsoftware.jeb.util.encoding.xml.XElement;
import com.pnfsoftware.jeb.util.encoding.xml.XNodeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class XNode
implements Node {
    XNodeList children = XNodeList.EMPTY;
    XNode parent;
    Map<String, Object> datamap;

    public void initChildren(List<XNode> list) {
        this.children = new XNodeList(list);
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        return this.children;
    }

    @Override
    public Node getFirstChild() {
        if (this.children.list.isEmpty()) {
            return null;
        }
        return this.children.list.get(0);
    }

    @Override
    public Node getLastChild() {
        if (this.children.list.isEmpty()) {
            return null;
        }
        return this.children.list.get(this.children.list.size() - 1);
    }

    @Override
    public Node getPreviousSibling() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getNextSibling() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        Node node = this;
        while (node != null) {
            if (!((node = node.getParentNode()) instanceof Document)) continue;
            return (Document)node;
        }
        return null;
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasChildNodes() {
        return this.children.getLength() > 0;
    }

    @Override
    public Node cloneNode(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return this.getAttributes() != null && this.getAttributes().getLength() > 0;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTextContent() throws DOMException {
        if (this.ofType(1, 6, 5, 11)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (XNode xNode : this.children.list) {
                if (xNode.getNodeType() == 8 || xNode.getNodeType() == 7) continue;
                stringBuilder.append(xNode.getTextContent());
            }
            return stringBuilder.toString();
        }
        if (this.ofType(2, 3, 4, 8, 7)) {
            return this.getNodeValue();
        }
        if (this.ofType(9, 10, 12)) {
            return null;
        }
        return null;
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameNode(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupPrefix(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupNamespaceURI(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEqualNode(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getFeature(String string, String string2) {
        return null;
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        if (this.datamap == null) {
            this.datamap = new HashMap<String, Object>();
        }
        if (object == null) {
            if (this.datamap == null) {
                return null;
            }
            return this.datamap.remove(object);
        }
        return this.datamap.put(string, object);
    }

    @Override
    public Object getUserData(String string) {
        if (this.datamap == null) {
            return null;
        }
        return this.datamap.get(string);
    }

    public boolean ofType(int ... nArray) {
        short s2 = this.getNodeType();
        for (int n2 : nArray) {
            if (n2 != s2) continue;
            return true;
        }
        return false;
    }

    public static XNode findNodeByName(Collection<? extends XNode> collection, String string) {
        Optional<XNode> optional = collection.stream().filter(xNode -> xNode.getNodeName().equals(string)).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }

    public static NodeList getDescendantElementsByTagName(XNode xNode, String string) {
        if (string == null) {
            return XNodeList.EMPTY;
        }
        ArrayList<XNode> arrayList = new ArrayList<XNode>();
        arrayList.add(xNode);
        boolean bl = string.equals("*");
        ArrayList<XElement> arrayList2 = new ArrayList<XElement>();
        while (!arrayList.isEmpty()) {
            XNode xNode2 = (XNode)arrayList.remove(0);
            for (XNode xNode3 : xNode2.children.list) {
                if (!(xNode3 instanceof XElement)) continue;
                XElement xElement = (XElement)xNode3;
                if (bl || string.equals(xElement.getTagName())) {
                    arrayList2.add(xElement);
                }
                arrayList.add(xElement);
            }
        }
        return new XNodeList(arrayList2);
    }
}

