/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.jflex;

import com.pnfsoftware.jeb.util.encoding.jflex.TokenType;
import com.pnfsoftware.jeb.util.format.Strings;

public class Token
implements Comparable<Token> {
    public final TokenType type;
    public final long start;
    public final int length;
    public final byte pairValue;
    public final short kind = 0;

    public Token(TokenType tokenType, long l2, int n2) {
        this.type = tokenType;
        this.start = l2;
        this.length = n2;
        this.pairValue = 0;
    }

    public Token(TokenType tokenType, long l2, int n2, byte by) {
        this.type = tokenType;
        this.start = l2;
        this.length = n2;
        this.pairValue = by;
    }

    public boolean equals(Object object) {
        if (object instanceof Token) {
            Token token = (Token)object;
            return this.start == token.start && this.length == token.length && this.type.equals((Object)token.type);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.start;
    }

    public String toString() {
        if (this.pairValue == 0) {
            return Strings.ff("%s (%d, %d)", new Object[]{this.type, this.start, this.length});
        }
        return Strings.ff("%s (%d, %d) (%d)", new Object[]{this.type, this.start, this.length, this.pairValue});
    }

    @Override
    public int compareTo(Token token) {
        if (this.start != token.start) {
            return (int)(this.start - token.start);
        }
        if (this.length != token.length) {
            return this.length - token.length;
        }
        return this.type.compareTo(token.type);
    }

    public long end() {
        return this.start + (long)this.length;
    }
}

