/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.cbor;

public class CborType {
    private final int m_major;
    private final int m_additional;

    private CborType(int n2, int n3) {
        this.m_major = n2;
        this.m_additional = n3;
    }

    public static String getName(int n2) {
        switch (n2) {
            case 4: {
                return "array";
            }
            case 2: {
                return "byte string";
            }
            case 7: {
                return "float/simple value";
            }
            case 5: {
                return "map";
            }
            case 1: {
                return "negative integer";
            }
            case 6: {
                return "tag";
            }
            case 3: {
                return "text string";
            }
            case 0: {
                return "unsigned integer";
            }
        }
        throw new IllegalArgumentException("Invalid major type: " + n2);
    }

    public static CborType valueOf(int n2) {
        return new CborType((n2 & 0xFF) >>> 5, n2 & 0x1F);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CborType cborType = (CborType)object;
        return this.m_major == cborType.m_major && this.m_additional == cborType.m_additional;
    }

    public int getAdditionalInfo() {
        return this.m_additional;
    }

    public int getMajorType() {
        return this.m_major;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.m_additional;
        n2 = 31 * n2 + this.m_major;
        return n2;
    }

    public boolean isBreakAllowed() {
        return this.m_major == 4 || this.m_major == 2 || this.m_major == 5 || this.m_major == 3;
    }

    public boolean isEqualType(CborType cborType) {
        if (cborType == null) {
            throw new IllegalArgumentException("Parameter cannot be null!");
        }
        return this.m_major == cborType.m_major;
    }

    public boolean isEqualType(int n2) {
        return this.m_major == (n2 & 0xFF) >>> 5;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CborType.getName(this.m_major)).append('(').append(this.m_additional).append(')');
        return stringBuilder.toString();
    }
}

