/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.cbor;

import java.io.IOException;
import java.io.OutputStream;

public class CborEncoder {
    private static final int NEG_INT_MASK = 32;
    private final OutputStream m_os;

    public CborEncoder(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream cannot be null!");
        }
        this.m_os = outputStream;
    }

    static int halfPrecisionToRawIntBits(float f) {
        int n2 = Float.floatToIntBits(f);
        int n3 = n2 >>> 16 & 0x8000;
        int n4 = (n2 & Integer.MAX_VALUE) + 4096;
        if (n4 >= 1199570944) {
            if ((n2 & Integer.MAX_VALUE) >= 1199570944) {
                if (n4 < 2139095040) {
                    return n3 | 0x7C00;
                }
                return n3 | 0x7C00 | (n2 & 0x7FFFFF) >>> 13;
            }
            return n3 | 0x7BFF;
        }
        if (n4 >= 0x38800000) {
            return n3 | n4 - 0x38000000 >>> 13;
        }
        if (n4 < 0x33000000) {
            return n3;
        }
        n4 = (n2 & Integer.MAX_VALUE) >>> 23;
        return n3 | (n2 & 0x7FFFFF | 0x800000) + (0x800000 >>> n4 - 102) >>> 126 - n4;
    }

    public void writeArrayStart() throws IOException {
        this.writeSimpleType(4, 31);
    }

    public void writeArrayStart(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid array-length!");
        }
        this.writeType(4, n2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.writeSimpleType(7, bl ? 21 : 20);
    }

    public void writeBreak() throws IOException {
        this.writeSimpleType(7, 31);
    }

    public void writeByteString(byte[] byArray) throws IOException {
        this.writeString(2, byArray);
    }

    public void writeByteStringStart() throws IOException {
        this.writeSimpleType(2, 31);
    }

    public void writeDouble(double d) throws IOException {
        this.writeUInt64(224, Double.doubleToRawLongBits(d));
    }

    public void writeFloat(float f) throws IOException {
        this.writeUInt32(224, Float.floatToRawIntBits(f));
    }

    public void writeHalfPrecisionFloat(float f) throws IOException {
        this.writeUInt16(224, CborEncoder.halfPrecisionToRawIntBits(f));
    }

    public void writeInt(long l2) throws IOException {
        long l3 = l2 >> 63;
        int n2 = (int)(l3 & 0x20L);
        l2 = l3 ^ l2;
        this.writeUInt(n2, l2);
    }

    public void writeInt16(int n2) throws IOException {
        int n3 = n2 >> 31;
        int n4 = n3 & 0x20;
        this.writeUInt16(n4, (n3 ^ n2) & 0xFFFF);
    }

    public void writeInt32(long l2) throws IOException {
        long l3 = l2 >> 63;
        int n2 = (int)(l3 & 0x20L);
        this.writeUInt32(n2, (int)((l3 ^ l2) & 0xFFFFFFFFL));
    }

    public void writeInt64(long l2) throws IOException {
        long l3 = l2 >> 63;
        int n2 = (int)(l3 & 0x20L);
        this.writeUInt64(n2, l3 ^ l2);
    }

    public void writeInt8(int n2) throws IOException {
        int n3 = n2 >> 31;
        int n4 = n3 & 0x20;
        this.writeUInt8(n4, (n3 ^ n2) & 0xFF);
    }

    public void writeMapStart() throws IOException {
        this.writeSimpleType(5, 31);
    }

    public void writeMapStart(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid length of map!");
        }
        this.writeType(5, n2);
    }

    public void writeNull() throws IOException {
        this.writeSimpleType(7, 22);
    }

    public void writeSimpleValue(byte by) throws IOException {
        int n2 = by & 0xFF;
        this.writeType(7, n2);
    }

    public void writeSmallInt(int n2) throws IOException {
        int n3 = n2 >> 31;
        int n4 = n3 & 0x20;
        n2 = Math.min(23, n3 ^ n2);
        this.m_os.write(n4 | n2);
    }

    public void writeTag(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Invalid tag specification, cannot be negative!");
        }
        this.writeType(6, l2);
    }

    public void writeTextString(String string) throws IOException {
        this.writeString(3, string == null ? null : string.getBytes("UTF-8"));
    }

    public void writeTextStringStart() throws IOException {
        this.writeSimpleType(3, 31);
    }

    public void writeUndefined() throws IOException {
        this.writeSimpleType(7, 23);
    }

    protected void writeSimpleType(int n2, int n3) throws IOException {
        this.m_os.write(n2 << 5 | n3 & 0x1F);
    }

    protected void writeString(int n2, byte[] byArray) throws IOException {
        int n3 = byArray == null ? 0 : byArray.length;
        this.writeType(n2, n3);
        for (int i = 0; i < n3; ++i) {
            this.m_os.write(byArray[i]);
        }
    }

    protected void writeType(int n2, long l2) throws IOException {
        this.writeUInt(n2 << 5, l2);
    }

    protected void writeUInt(int n2, long l2) throws IOException {
        if (l2 < 24L) {
            this.m_os.write((int)((long)n2 | l2));
        } else if (l2 < 256L) {
            this.writeUInt8(n2, (int)l2);
        } else if (l2 < 65536L) {
            this.writeUInt16(n2, (int)l2);
        } else if (l2 < 0x100000000L) {
            this.writeUInt32(n2, (int)l2);
        } else {
            this.writeUInt64(n2, l2);
        }
    }

    protected void writeUInt16(int n2, int n3) throws IOException {
        this.m_os.write(n2 | 0x19);
        this.m_os.write(n3 >> 8);
        this.m_os.write(n3 & 0xFF);
    }

    protected void writeUInt32(int n2, int n3) throws IOException {
        this.m_os.write(n2 | 0x1A);
        this.m_os.write(n3 >> 24);
        this.m_os.write(n3 >> 16);
        this.m_os.write(n3 >> 8);
        this.m_os.write(n3 & 0xFF);
    }

    protected void writeUInt64(int n2, long l2) throws IOException {
        this.m_os.write(n2 | 0x1B);
        this.m_os.write((int)(l2 >> 56));
        this.m_os.write((int)(l2 >> 48));
        this.m_os.write((int)(l2 >> 40));
        this.m_os.write((int)(l2 >> 32));
        this.m_os.write((int)(l2 >> 24));
        this.m_os.write((int)(l2 >> 16));
        this.m_os.write((int)(l2 >> 8));
        this.m_os.write((int)(l2 & 0xFFL));
    }

    protected void writeUInt8(int n2, int n3) throws IOException {
        this.m_os.write(n2 | 0x18);
        this.m_os.write(n3 & 0xFF);
    }
}

