/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.cbor;

import com.pnfsoftware.jeb.util.encoding.cbor.CborType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class CborDecoder {
    protected final PushbackInputStream m_is;

    public CborDecoder(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null!");
        }
        this.m_is = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
    }

    private static void fail(String string, Object ... objectArray) throws IOException {
        throw new IOException(String.format(string, objectArray));
    }

    private static String lengthToString(int n2) {
        return n2 < 0 ? "no payload" : (n2 == 24 ? "one byte" : (n2 == 25 ? "two bytes" : (n2 == 26 ? "four bytes" : (n2 == 27 ? "eight bytes" : "(unknown)"))));
    }

    public CborType peekType() throws IOException {
        int n2 = this.m_is.read();
        if (n2 < 0) {
            return null;
        }
        this.m_is.unread(n2);
        return CborType.valueOf(n2);
    }

    public long readArrayLength() throws IOException {
        return this.readMajorTypeWithSize(4);
    }

    public boolean readBoolean() throws IOException {
        int n2 = this.readMajorType(7);
        if (n2 != 20 && n2 != 21) {
            CborDecoder.fail("Unexpected boolean value: %d!", n2);
        }
        return n2 == 21;
    }

    public Object readBreak() throws IOException {
        this.readMajorTypeExact(7, 31);
        return null;
    }

    public byte[] readByteString() throws IOException {
        long l2 = this.readMajorTypeWithSize(2);
        if (l2 < 0L) {
            CborDecoder.fail("Infinite-length byte strings not supported!", new Object[0]);
        }
        if (l2 > Integer.MAX_VALUE) {
            CborDecoder.fail("String length too long!", new Object[0]);
        }
        return this.readFully(new byte[(int)l2]);
    }

    public long readByteStringLength() throws IOException {
        return this.readMajorTypeWithSize(2);
    }

    public double readDouble() throws IOException {
        this.readMajorTypeExact(7, 27);
        return Double.longBitsToDouble(this.readUInt64());
    }

    public float readFloat() throws IOException {
        this.readMajorTypeExact(7, 26);
        return Float.intBitsToFloat((int)this.readUInt32());
    }

    public double readHalfPrecisionFloat() throws IOException {
        this.readMajorTypeExact(7, 25);
        int n2 = this.readUInt16();
        int n3 = n2 >> 10 & 0x1F;
        int n4 = n2 & 0x3FF;
        double d = n3 == 0 ? (double)n4 * Math.pow(2.0, -24.0) : (n3 != 31 ? (double)(n4 + 1024) * Math.pow(2.0, n3 - 25) : (n4 != 0 ? Double.NaN : Double.POSITIVE_INFINITY));
        return (n2 & 0x8000) == 0 ? d : -d;
    }

    public long readInt() throws IOException {
        int n2 = this.m_is.read();
        long l2 = this.expectIntegerType(n2);
        return l2 ^ this.readUInt(n2 & 0x1F, false);
    }

    public int readInt16() throws IOException {
        int n2 = this.m_is.read();
        long l2 = this.expectIntegerType(n2);
        return (int)(l2 ^ this.readUIntExact(25, n2 & 0x1F));
    }

    public long readInt32() throws IOException {
        int n2 = this.m_is.read();
        long l2 = this.expectIntegerType(n2);
        return l2 ^ this.readUIntExact(26, n2 & 0x1F);
    }

    public long readInt64() throws IOException {
        int n2 = this.m_is.read();
        long l2 = this.expectIntegerType(n2);
        return l2 ^ this.readUIntExact(27, n2 & 0x1F);
    }

    public int readInt8() throws IOException {
        int n2 = this.m_is.read();
        long l2 = this.expectIntegerType(n2);
        return (int)(l2 ^ this.readUIntExact(24, n2 & 0x1F));
    }

    public long readMapLength() throws IOException {
        return this.readMajorTypeWithSize(5);
    }

    public Object readNull() throws IOException {
        this.readMajorTypeExact(7, 22);
        return null;
    }

    public byte readSimpleValue() throws IOException {
        this.readMajorTypeExact(7, 24);
        return (byte)this.readUInt8();
    }

    public int readSmallInt() throws IOException {
        int n2 = this.m_is.read();
        long l2 = this.expectIntegerType(n2);
        return (int)(l2 ^ this.readUIntExact(-1, n2 & 0x1F));
    }

    public long readTag() throws IOException {
        return this.readUInt(this.readMajorType(6), false);
    }

    public String readTextString() throws IOException {
        long l2 = this.readMajorTypeWithSize(3);
        if (l2 < 0L) {
            CborDecoder.fail("Infinite-length text strings not supported!", new Object[0]);
        }
        if (l2 > Integer.MAX_VALUE) {
            CborDecoder.fail("String length too long!", new Object[0]);
        }
        return new String(this.readFully(new byte[(int)l2]), "UTF-8");
    }

    public long readTextStringLength() throws IOException {
        return this.readMajorTypeWithSize(3);
    }

    public Object readUndefined() throws IOException {
        this.readMajorTypeExact(7, 23);
        return null;
    }

    protected long expectIntegerType(int n2) throws IOException {
        int n3 = (n2 & 0xFF) >>> 5;
        if (n3 != 0 && n3 != 1) {
            CborDecoder.fail("Unexpected type: %s, expected type %s or %s!", CborType.getName(n3), CborType.getName(0), CborType.getName(1));
        }
        return -n3;
    }

    protected int readMajorType(int n2) throws IOException {
        int n3 = this.m_is.read();
        if (n2 != (n3 >>> 5 & 7)) {
            CborDecoder.fail("Unexpected type: %s, expected: %s!", CborType.getName(n3), CborType.getName(n2));
        }
        return n3 & 0x1F;
    }

    protected void readMajorTypeExact(int n2, int n3) throws IOException {
        int n4 = this.readMajorType(n2);
        if ((n4 ^ n3) != 0) {
            CborDecoder.fail("Unexpected subtype: %d, expected: %d!", n4, n3);
        }
    }

    protected long readMajorTypeWithSize(int n2) throws IOException {
        return this.readUInt(this.readMajorType(n2), true);
    }

    protected long readUInt(int n2, boolean bl) throws IOException {
        long l2 = -1L;
        if (n2 < 24) {
            l2 = n2;
        } else if (n2 == 24) {
            l2 = this.readUInt8();
        } else if (n2 == 25) {
            l2 = this.readUInt16();
        } else if (n2 == 26) {
            l2 = this.readUInt32();
        } else if (n2 == 27) {
            l2 = this.readUInt64();
        } else if (bl && n2 == 31) {
            return -1L;
        }
        if (l2 < 0L) {
            CborDecoder.fail("Not well-formed CBOR integer found, invalid length: %d!", l2);
        }
        return l2;
    }

    protected int readUInt16() throws IOException {
        byte[] byArray = this.readFully(new byte[2]);
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    protected long readUInt32() throws IOException {
        byte[] byArray = this.readFully(new byte[4]);
        return (long)((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF) & 0xFFFFFFFFL;
    }

    protected long readUInt64() throws IOException {
        byte[] byArray = this.readFully(new byte[8]);
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    protected int readUInt8() throws IOException {
        return this.m_is.read() & 0xFF;
    }

    protected long readUIntExact(int n2, int n3) throws IOException {
        if (n2 == -1 && n3 >= 24 || n2 >= 0 && n3 != n2) {
            CborDecoder.fail("Unexpected payload/length! Expected %s, but got %s.", CborDecoder.lengthToString(n2), CborDecoder.lengthToString(n3));
        }
        return this.readUInt(n3, false);
    }

    private byte[] readFully(byte[] byArray) throws IOException {
        int n2;
        int n3 = byArray.length;
        int n4 = 0;
        for (int i = 0; i < n3; i += n2) {
            n2 = this.m_is.read(byArray, n4 + i, n3 - i);
            if (n2 >= 0) continue;
            throw new EOFException();
        }
        return byArray;
    }
}

