/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import com.pnfsoftware.jeb.core.input.IInput;
import java.nio.ByteBuffer;

public class MimeType {
    public static final String IMAGE_BMP = "image/BMP";
    public static final String IMAGE_CRW = "image/x-canon-crw";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_ICO = "image/vnd.microsoft.icon";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_PSD = "image/vnd.adobe.photoshop";
    public static final String IMAGE_TIFF = "image/tiff";
    public static final String IMAGE_WEBP = "image/webp";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_7Z = "application/x-7z-compressed";
    public static final String APPLICATION_TAR = "application/x-tar";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_OCTETSTREAM = "application/octet-stream";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_HTML = "text/html";
    public static final String AUDIO_WAV = "audio/vnd.wave";
    private static final String AUDIO_OGG = "audio/ogg";
    private static final String AUDIO_MPEG = "audio/mpeg";
    private static final String AUDIO_MPEG4 = "audio/mp4";
    private static final String AUDIO_MIDI = "audio/midi";
    private static final String VIDEO_AVI = "video/vnd.avi";
    private static final String VIDEO_OGG = "video/ogg";
    private static final String VIDEO_MPEG = "video/mpeg";
    private static final String VIDEO_MPEG4 = "video/mp4";
    private static final String VIDEO_3GPP = "video/3gpp";
    private static final String FONT_TTF = "font/ttf";

    public static String determineFromContent(IInput iInput) {
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer == null) {
            return APPLICATION_OCTETSTREAM;
        }
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return MimeType.determineFromContent(byArray, iInput.getName());
    }

    public static String determineFromContent(byte[] byArray) {
        return MimeType.determineFromContent(byArray, null);
    }

    public static String determineFromContent(byte[] byArray, String string) {
        if (MimeType.checkBytes(byArray, 0, 137, 80, 78, 71)) {
            return IMAGE_PNG;
        }
        if (byArray.length >= 4 && MimeType.checkBytes(byArray, 0, 255, 216, 255)) {
            return IMAGE_JPEG;
        }
        if (MimeType.checkBytes(byArray, 0, "GIF87a") || MimeType.checkBytes(byArray, 0, "GIF89a")) {
            return IMAGE_GIF;
        }
        if (MimeType.checkBytes(byArray, 0, "BM") && MimeType.checkBytes(byArray, 6, 0, 0, 0, 0)) {
            return IMAGE_BMP;
        }
        if (MimeType.checkBytes(byArray, 0, 73, 73, 42, 0) || MimeType.checkBytes(byArray, 0, 77, 77, 0, 42)) {
            return IMAGE_TIFF;
        }
        if (MimeType.checkBytes(byArray, 0, "RIFF")) {
            int n2 = 4;
            if (MimeType.checkBytes(byArray, 4 + n2, "WEBP")) {
                return IMAGE_WEBP;
            }
            if (MimeType.checkBytes(byArray, 4 + n2, "WAVEfmt")) {
                return AUDIO_WAV;
            }
            if (MimeType.checkBytes(byArray, 4 + n2, "AVI LIST")) {
                return VIDEO_AVI;
            }
        }
        if (MimeType.checkBytes(byArray, 0, "OggS")) {
            if (string != null && (string.endsWith("ogv") || string.endsWith("ogm"))) {
                return VIDEO_OGG;
            }
            return AUDIO_OGG;
        }
        if (MimeType.checkBytes(byArray, 4, "ftyp")) {
            if (MimeType.checkBytes(byArray, 8, "M4A ")) {
                return AUDIO_MPEG4;
            }
            if (MimeType.checkBytes(byArray, 8, "mmp4") || MimeType.checkBytes(byArray, 8, "mp4") || MimeType.checkBytes(byArray, 8, "isom") || MimeType.checkBytes(byArray, 8, "MSNV")) {
                return VIDEO_MPEG4;
            }
            if (MimeType.checkBytes(byArray, 8, "3g")) {
                return VIDEO_3GPP;
            }
        }
        if (MimeType.checkBytes(byArray, 0, 255, 251) || MimeType.checkBytes(byArray, 0, 255, 243) || MimeType.checkBytes(byArray, 0, 255, 242) || MimeType.checkBytes(byArray, 0, "ID3")) {
            return AUDIO_MPEG;
        }
        if (MimeType.checkBytes(byArray, 0, 0, 0, 1, 179)) {
            return VIDEO_MPEG;
        }
        if (MimeType.checkBytes(byArray, 0, "MThd")) {
            return AUDIO_MIDI;
        }
        if (MimeType.checkBytes(byArray, 0, 0, 1, 0, 0, 0)) {
            return FONT_TTF;
        }
        return APPLICATION_OCTETSTREAM;
    }

    private static boolean checkBytes(byte[] byArray, int n2, int ... nArray) {
        if (n2 + nArray.length > byArray.length) {
            return false;
        }
        for (int n3 : nArray) {
            if (byArray[n2] != (byte)n3) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean checkBytes(byte[] byArray, int n2, char ... cArray) {
        if (n2 + cArray.length > byArray.length) {
            return false;
        }
        for (char c2 : cArray) {
            if (byArray[n2] != (byte)c2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean checkBytes(byte[] byArray, int n2, String string) {
        return MimeType.checkBytes(byArray, n2, string.toCharArray());
    }
}

