/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import com.pnfsoftware.jeb.util.encoding.BadEncodingException;
import com.pnfsoftware.jeb.util.math.MathUtil;

public class LEB128 {
    public static Value read_int7(byte[] byArray, int n2) throws BadEncodingException {
        Value value = LEB128.readSLEB128(byArray, n2);
        if (value.bytelen > 1) {
            throw new BadEncodingException("Invalid varint7", n2);
        }
        value.value = MathUtil.signExtend(value.value, 7);
        return value;
    }

    public static Value read_int16(byte[] byArray, int n2) throws BadEncodingException {
        Value value = LEB128.readSLEB128(byArray, n2);
        if (value.bytelen > 3) {
            throw new BadEncodingException("Invalid varint16", n2);
        }
        value.value = MathUtil.signExtend(value.value, 16);
        return value;
    }

    public static Value read_int32(byte[] byArray, int n2) throws BadEncodingException {
        Value value = LEB128.readSLEB128(byArray, n2);
        if (value.bytelen > 5) {
            throw new BadEncodingException("Invalid varint32", n2);
        }
        value.value = MathUtil.signExtend(value.value, 32);
        return value;
    }

    public static Value read_int64(byte[] byArray, int n2) throws BadEncodingException {
        Value value = LEB128.readSLEB128(byArray, n2);
        return value;
    }

    public static Value read_uint1(byte[] byArray, int n2) throws BadEncodingException {
        Value value = LEB128.readULEB128(byArray, n2);
        if (value.bytelen > 1 || value.value > 1L) {
            throw new BadEncodingException("Invalid varuint1", n2);
        }
        return value;
    }

    public static Value read_uint7(byte[] byArray, int n2) throws BadEncodingException {
        Value value = LEB128.readULEB128(byArray, n2);
        if (value.bytelen > 1 || value.value > 127L) {
            throw new BadEncodingException("Invalid varuint7", n2);
        }
        return value;
    }

    public static Value read_uint16(byte[] byArray, int n2) throws BadEncodingException {
        Value value = LEB128.readULEB128(byArray, n2);
        if (value.bytelen > 3 || value.value > 65535L) {
            throw new BadEncodingException("Invalid varuint16", n2);
        }
        return value;
    }

    public static Value read_uint32(byte[] byArray, int n2) throws BadEncodingException {
        Value value = LEB128.readULEB128(byArray, n2);
        if (value.bytelen > 5 || value.value > 0xFFFFFFFFL) {
            throw new BadEncodingException("Invalid varuint32", n2);
        }
        return value;
    }

    public static Value read_uint64(byte[] byArray, int n2) throws BadEncodingException {
        Value value = LEB128.readULEB128(byArray, n2);
        return value;
    }

    private static Value readULEB128(byte[] byArray, int n2) throws BadEncodingException {
        long l2 = 0L;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n3 < 0) {
            if (n5 == 10) {
                throw new BadEncodingException("Illegal ULEB128-encoded integer", n2 + n5);
            }
            n3 = byArray[n2 + n5];
            l2 |= (long)(n3 & 0x7F) << n4;
            n4 += 7;
            ++n5;
        }
        return new Value(l2, n5);
    }

    private static Value readSLEB128(byte[] byArray, int n2) throws BadEncodingException {
        long l2 = 0L;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n3 < 0) {
            if (n4 == 10) {
                throw new BadEncodingException("Illegal SLEB128-encoded integer", n2 + n4);
            }
            n3 = byArray[n2 + n4];
            l2 |= (long)(n3 & 0x7F) << n5;
            n5 += 7;
            ++n4;
        }
        if ((n3 & 0x40) != 0) {
            if (n4 == 1) {
                l2 |= 0xFFFFFFFFFFFFFF80L;
            } else if (n4 == 2) {
                l2 |= 0xFFFFFFFFFFFFC000L;
            } else if (n4 == 3) {
                l2 |= 0xFFFFFFFFFFE00000L;
            } else if (n4 == 4) {
                l2 |= 0xFFFFFFFFF0000000L;
            } else if (n4 == 5) {
                l2 |= 0xFFFFFFF800000000L;
            } else if (n4 == 6) {
                l2 |= 0xFFFFFC0000000000L;
            } else if (n4 == 7) {
                l2 |= 0xFFFE000000000000L;
            } else if (n4 == 8) {
                l2 |= 0xFF00000000000000L;
            } else if (n4 == 9) {
                l2 |= Long.MIN_VALUE;
            }
        }
        return new Value(l2, n4);
    }

    public static class Value {
        long value;
        int bytelen;

        public Value(long l2, int n2) {
            this.value = l2;
            this.bytelen = n2;
        }

        public long get() {
            return this.value;
        }

        public int getEncodingLength() {
            return this.bytelen;
        }
    }
}

