/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IntegerLEB128 {
    public static void writeULEB128(OutputStream outputStream, int n2) throws IOException {
        if ((n2 & 0xFFFFFF80) == 0) {
            outputStream.write(n2);
        } else if ((n2 & 0xFFFFC000) == 0) {
            outputStream.write(0x80 | n2 & 0x7F);
            outputStream.write(n2 >>> 7 & 0x7F);
        } else if ((n2 & 0xFFE00000) == 0) {
            outputStream.write(0x80 | n2 & 0x7F);
            outputStream.write(0x80 | n2 >>> 7 & 0x7F);
            outputStream.write(n2 >>> 14 & 0x7F);
        } else if ((n2 & 0xF0000000) == 0) {
            outputStream.write(0x80 | n2 & 0x7F);
            outputStream.write(0x80 | n2 >>> 7 & 0x7F);
            outputStream.write(0x80 | n2 >>> 14 & 0x7F);
            outputStream.write(n2 >>> 21 & 0x7F);
        } else {
            outputStream.write(0x80 | n2 & 0x7F);
            outputStream.write(0x80 | n2 >>> 7 & 0x7F);
            outputStream.write(0x80 | n2 >>> 14 & 0x7F);
            outputStream.write(0x80 | n2 >>> 21 & 0x7F);
            outputStream.write(n2 >>> 28);
        }
    }

    public static int readULEB128(InputStream inputStream) throws IOException {
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while ((n3 & 0x80) != 0) {
            if (n5 == 5) {
                throw new IOException("Illegal ULEB128-encoded integer");
            }
            n3 = inputStream.read();
            if (n3 == -1) {
                throw new IOException("Not enough data");
            }
            n2 |= (n3 & 0x7F) << n4;
            n4 += 7;
            ++n5;
        }
        return n2;
    }

    public static DecodedInt decodeULEB128(InputStream inputStream) throws IOException {
        DecodedInt decodedInt = new DecodedInt();
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while ((n3 & 0x80) != 0) {
            if (n5 == 5) {
                throw new IOException("Illegal ULEB128-encoded integer");
            }
            n3 = inputStream.read();
            ++decodedInt.encodedSize;
            if (n3 == -1) {
                throw new IOException("Not enough data");
            }
            n2 |= (n3 & 0x7F) << n4;
            n4 += 7;
            ++n5;
        }
        decodedInt.value = n2;
        return decodedInt;
    }

    public static void writeSLEB128(OutputStream outputStream, int n2) throws IOException {
        boolean bl = true;
        while (bl) {
            int n3 = n2 & 0x7F;
            if ((n2 >>= 7) == 0 && (n3 & 0x40) == 0 || n2 == -1 && (n3 & 0x40) != 0) {
                bl = false;
            } else {
                n3 |= 0x80;
            }
            outputStream.write(n3);
        }
    }

    public static class DecodedInt {
        public int value;
        public int encodedSize;
    }
}

