/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

public class HashCalculator {
    private static final int PAGE_SIZE = 16384;
    public static final int CRC32 = 1;
    public static final int ADLER32 = 2;
    public static final int MD5 = 4;
    public static final int SHA1 = 8;
    public static final int SHA256 = 16;
    private InputStream in;
    private int flags;
    private boolean computed;
    private long size = -1L;
    private long crc32 = -1L;
    private long adler32 = -1L;
    private byte[] md5;
    private byte[] sha1;
    private byte[] sha256;

    public static final Long crc32(InputStream inputStream) {
        return HashCalculator.singleCrcCalculation(inputStream, 1);
    }

    public static final Long adler32(InputStream inputStream) {
        return HashCalculator.singleCrcCalculation(inputStream, 2);
    }

    private static final Long singleCrcCalculation(InputStream inputStream, int n2) {
        try {
            HashCalculator hashCalculator = new HashCalculator(inputStream, n2);
            if (!hashCalculator.compute()) {
                return null;
            }
            switch (n2) {
                case 1: {
                    return hashCalculator.getCrc32();
                }
                case 2: {
                    return hashCalculator.getAdler32();
                }
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static final byte[] md5(InputStream inputStream) {
        return HashCalculator.singleHashCalculation(inputStream, 4);
    }

    public static final byte[] sha1(InputStream inputStream) {
        return HashCalculator.singleHashCalculation(inputStream, 8);
    }

    public static final byte[] sha256(InputStream inputStream) {
        return HashCalculator.singleHashCalculation(inputStream, 16);
    }

    private static final byte[] singleHashCalculation(InputStream inputStream, int n2) {
        try {
            HashCalculator hashCalculator = new HashCalculator(inputStream, n2);
            if (!hashCalculator.compute()) {
                return null;
            }
            switch (n2) {
                case 4: {
                    return hashCalculator.getMd5();
                }
                case 8: {
                    return hashCalculator.getSha1();
                }
                case 16: {
                    return hashCalculator.getSha256();
                }
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public HashCalculator(InputStream inputStream, int n2) {
        this.in = inputStream;
        this.flags = n2;
    }

    public long getSize() {
        if (this.size < 0L) {
            throw new IllegalStateException("Stream size is currently undetermined");
        }
        return this.size;
    }

    public long getCrc32() {
        if (!this.doAlgo(1) || this.crc32 < 0L) {
            throw new IllegalStateException("CRC-32 value was not computed");
        }
        return this.crc32;
    }

    public long getAdler32() {
        if (!this.doAlgo(2) || this.adler32 < 0L) {
            throw new IllegalStateException("Adler32 value was not computed");
        }
        return this.adler32;
    }

    public byte[] getMd5() {
        if (!this.doAlgo(4) || this.md5 == null) {
            throw new IllegalStateException("MD5 value was not computed");
        }
        return this.md5;
    }

    public byte[] getSha1() {
        if (!this.doAlgo(8) || this.sha1 == null) {
            throw new IllegalStateException("SHA-1 value was not computed");
        }
        return this.sha1;
    }

    public byte[] getSha256() {
        if (!this.doAlgo(16) || this.sha256 == null) {
            throw new IllegalStateException("SHA-256 value was not computed");
        }
        return this.sha256;
    }

    private boolean doAlgo(int n2) {
        return (this.flags & n2) != 0;
    }

    public boolean compute() throws IOException {
        int n2;
        MessageDigest messageDigest;
        MessageDigest messageDigest2;
        MessageDigest messageDigest3;
        Adler32 adler32;
        CRC32 cRC32;
        if (this.computed) {
            throw new IllegalStateException("Digests were already computed");
        }
        this.computed = true;
        try {
            cRC32 = this.doAlgo(1) ? new CRC32() : null;
            adler32 = this.doAlgo(2) ? new Adler32() : null;
            messageDigest3 = this.doAlgo(4) ? MessageDigest.getInstance("MD5") : null;
            messageDigest2 = this.doAlgo(8) ? MessageDigest.getInstance("SHA-1") : null;
            messageDigest = this.doAlgo(16) ? MessageDigest.getInstance("SHA-256") : null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
        long l2 = 0L;
        byte[] byArray = new byte[16384];
        while ((n2 = this.in.read(byArray, 0, byArray.length)) != -1) {
            if (cRC32 != null) {
                cRC32.update(byArray, 0, n2);
            }
            if (adler32 != null) {
                adler32.update(byArray, 0, n2);
            }
            if (messageDigest3 != null) {
                messageDigest3.update(byArray, 0, n2);
            }
            if (messageDigest2 != null) {
                messageDigest2.update(byArray, 0, n2);
            }
            if (messageDigest != null) {
                messageDigest.update(byArray, 0, n2);
            }
            l2 += (long)n2;
        }
        this.size = l2;
        if (cRC32 != null) {
            this.crc32 = cRC32.getValue();
        }
        if (adler32 != null) {
            this.adler32 = adler32.getValue();
        }
        if (messageDigest3 != null) {
            this.md5 = messageDigest3.digest();
        }
        if (messageDigest2 != null) {
            this.sha1 = messageDigest2.digest();
        }
        if (messageDigest != null) {
            this.sha256 = messageDigest.digest();
        }
        return true;
    }
}

