/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import com.pnfsoftware.jeb.util.base.Assert;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class Hash {
    private static final long BLKSIZE = 65536L;
    private static final byte[] blk = new byte[65536];

    public static int calculateCRC32(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return (int)(cRC32.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte[] calculateMD5(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static byte[] calculateSHA1(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static byte[] calculateSHA256(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static void checksumBlockFileUpdate(Checksum checksum, File file) throws IOException {
        Hash.checksumBlockFileUpdate(checksum, file, 0L, file.length());
    }

    public static void checksumBlockFileUpdate(Checksum checksum, File file, long l2, long l3) throws IOException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            randomAccessFile.seek(l2);
            Hash.checksumBlockFileUpdate(checksum, randomAccessFile, l3);
        }
    }

    public static void checksumBlockFileUpdate(Checksum checksum, RandomAccessFile randomAccessFile, long l2) throws IOException {
        long l3 = randomAccessFile.getFilePointer();
        long l4 = l2;
        if (l2 <= 65536L) {
            int n2 = (int)l2;
            if (randomAccessFile.read(blk, 0, n2) != n2) {
                throw new IOException();
            }
            checksum.update(blk, 0, n2);
            l4 -= (long)n2;
        } else {
            int n3;
            long l5 = l3 & 0xFFFFL;
            if (l5 != 0L) {
                n3 = (int)(65536L - l5);
                if (randomAccessFile.read(blk, 0, n3) != n3) {
                    throw new IOException();
                }
                checksum.update(blk, 0, n3);
                l4 -= (long)n3;
            }
            while (l4 > 0L) {
                n3 = (int)Math.min(65536L, l4);
                if (randomAccessFile.read(blk, 0, n3) != n3) {
                    throw new IOException();
                }
                checksum.update(blk, 0, n3);
                l4 -= (long)n3;
            }
        }
        Assert.a(l4 == 0L);
    }
}

