/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import com.pnfsoftware.jeb.util.format.Strings;

public class Conversion {
    private static final int DEFAULT_BASE = 10;

    public static int toInt(Object object) {
        return Conversion.toInt(object, 0);
    }

    public static int toInt(Object object, int n2) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return Conversion.stringToInt((String)object, n2);
        }
        return n2;
    }

    public static long toLong(Object object) {
        return Conversion.toLong(object, 0L);
    }

    public static long toLong(Object object, long l2) {
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            return Conversion.stringToLong((String)object, l2);
        }
        return l2;
    }

    private static Long stringToLongUnsafe(String string, int n2) throws NumberFormatException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if ((string = string.trim()).endsWith("L")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > 1 && string.charAt(0) == '-' && string.charAt(1) != '-') {
            Long l2 = Conversion.stringToLongUnsafe(string = string.substring(1).trim(), n2);
            if (l2 == null) {
                return null;
            }
            return -1L * l2;
        }
        try {
            Object object = string;
            int n3 = n2;
            if (string.startsWith("0x")) {
                object = string.substring(2);
                n3 = 16;
            } else if (string.endsWith("h")) {
                object = string.substring(0, string.length() - 1);
                n3 = 16;
            } else if (n2 == 10 && string.length() >= 2 && string.startsWith("0")) {
                object = string.substring(1);
                n3 = 8;
            }
            if (n3 == 16 && ((String)object).length() >= 10 && ((String)object).charAt(((String)object).length() - 9) == '\'') {
                object = ((String)object).substring(0, ((String)object).length() - 9) + ((String)object).substring(((String)object).length() - 8);
            }
            return Long.parseLong((String)object, n3);
        }
        catch (Exception exception) {
            try {
                if (Conversion.isNegativeHexLong(string)) {
                    String string2 = Conversion.getHexRaw(string);
                    long l3 = Long.parseLong(string2.substring(0, 1), 16);
                    return l3 << 60 | Long.parseLong(string2.substring(1), 16);
                }
            }
            catch (Exception exception2) {
                return null;
            }
            return null;
        }
    }

    public static Long stringToLongUnsafe(String string) {
        return Conversion.stringToLongUnsafe(string, 10);
    }

    public static long stringToLong(String string, long l2, int n2) {
        Long l3 = Conversion.stringToLongUnsafe(string, n2);
        if (l3 == null) {
            return l2;
        }
        return l3;
    }

    public static long stringToLong(String string, long l2) {
        return Conversion.stringToLong(string, l2, 10);
    }

    public static long stringToLong(String string) {
        return Conversion.stringToLong(string, 0L);
    }

    private static Integer stringToIntUnsafe(String string, int n2) throws NumberFormatException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if ((string = string.trim()).length() > 1 && string.charAt(0) == '-' && string.charAt(1) != '-') {
            Integer n3 = Conversion.stringToIntUnsafe(string = string.substring(1).trim(), n2);
            if (n3 == null) {
                return null;
            }
            return -1 * n3;
        }
        try {
            if (string.startsWith("0x")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            if (string.endsWith("h")) {
                return Integer.parseInt(string.substring(0, string.length() - 1), 16);
            }
            if (n2 == 10 && string.length() >= 2 && string.startsWith("0")) {
                return Integer.parseInt(string.substring(1), 8);
            }
            return Integer.parseInt(string, n2);
        }
        catch (Exception exception) {
            try {
                if (Conversion.isNegativeHexInt(string)) {
                    String string2 = Conversion.getHexRaw(string);
                    int n4 = Integer.parseInt(string2.substring(0, 1), 16);
                    return n4 << 28 | Integer.parseInt(string2.substring(1), 16);
                }
            }
            catch (Exception exception2) {
                return null;
            }
            return null;
        }
    }

    public static Integer stringToIntUnsafe(String string) throws NumberFormatException {
        return Conversion.stringToIntUnsafe(string, 10);
    }

    public static int stringToInt(String string, int n2, int n3) {
        Integer n4 = Conversion.stringToIntUnsafe(string, n3);
        if (n4 == null) {
            return n2;
        }
        return n4;
    }

    public static int stringToInt(String string, int n2) {
        return Conversion.stringToInt(string, n2, 10);
    }

    public static int stringToInt(String string) {
        return Conversion.stringToInt(string, 0, 10);
    }

    private static boolean isNegativeHexLong(String string) {
        return Conversion.isNegativeHex(string, 16);
    }

    private static boolean isNegativeHexInt(String string) {
        return Conversion.isNegativeHex(string, 8);
    }

    private static boolean isNegativeHex(String string, int n2) {
        String string2 = Conversion.getHexRaw(string);
        if (string2 == null || string2.length() == string.length() || Strings.isBlank(string2)) {
            return false;
        }
        return Conversion.isNegative(string2, n2);
    }

    private static boolean isNegative(String string, int n2) {
        string = string.toLowerCase();
        char c2 = string.charAt(0);
        return string.length() == n2 && (c2 == '8' || c2 == '9' || c2 >= 'a' && c2 <= 'f');
    }

    private static String getHexRaw(String string) {
        if ((string = string.toLowerCase()).startsWith("0x")) {
            string = string.substring(2);
        } else if (string.endsWith("h")) {
            string = string.substring(0, string.length() - 1);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isDigit(c2) || c2 >= 'a' && c2 <= 'f') continue;
            return null;
        }
        return string;
    }

    public static int getHexPossibility(String string) {
        if (string.isEmpty()) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 >= '0' && c2 <= '9') {
                n2 = Math.max(1, n2);
                continue;
            }
            if (c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') {
                n2 = Math.max(2, n2);
                continue;
            }
            if (c2 == '\'' && string.length() - i - 1 == 8 || (c2 == 'l' || c2 == 'L') && i == string.length() - 1) continue;
            return 0;
        }
        return n2;
    }
}

