/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.WeakConcurrentMap;
import java.util.Iterator;
import java.util.Map;

public class WeakConcurrentSet<V>
implements Iterable<V>,
Runnable {
    final WeakConcurrentMap<V, Boolean> target;

    public WeakConcurrentSet(Cleaner cleaner) {
        switch (cleaner) {
            case INLINE: {
                this.target = new WeakConcurrentMap.WithInlinedExpunction<V, Boolean>();
                break;
            }
            case THREAD: 
            case MANUAL: {
                this.target = new WeakConcurrentMap(cleaner == Cleaner.THREAD);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public boolean add(V v2) {
        return this.target.put((Boolean)v2, Boolean.TRUE) == null;
    }

    public boolean contains(V v2) {
        return this.target.containsKey(v2);
    }

    public boolean remove(V v2) {
        return this.target.remove(v2) != null;
    }

    public void clear() {
        this.target.clear();
    }

    public int approximateSize() {
        return this.target.approximateSize();
    }

    @Override
    public void run() {
        this.target.run();
    }

    public void expungeStaleEntries() {
        this.target.expungeStaleEntries();
    }

    public Thread getCleanerThread() {
        return this.target.getCleanerThread();
    }

    @Override
    public Iterator<V> iterator() {
        return new ReducingIterator<V>(this.target.iterator());
    }

    private static class ReducingIterator<V>
    implements Iterator<V> {
        private final Iterator<Map.Entry<V, Boolean>> iterator;

        private ReducingIterator(Iterator<Map.Entry<V, Boolean>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public V next() {
            return this.iterator.next().getKey();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    public static enum Cleaner {
        THREAD,
        INLINE,
        MANUAL;

    }
}

