/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class WeakConcurrentMap<K, V>
extends ReferenceQueue<K>
implements Iterable<Map.Entry<K, V>>,
Runnable {
    private static final AtomicLong ID = new AtomicLong();
    public final ConcurrentMap<IWeakKey<K>, V> target = new ConcurrentHashMap<IWeakKey<K>, V>();
    private final Thread thread;

    public WeakConcurrentMap(boolean bl) {
        if (bl) {
            this.thread = new Thread(this);
            this.thread.setName("weak-ref-cleaner-" + ID.getAndIncrement());
            this.thread.setPriority(1);
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.thread = null;
        }
    }

    public V get(K k) {
        V v2;
        if (k == null) {
            throw new NullPointerException();
        }
        Object v3 = this.target.get(new LatentKey<K>(k));
        if (v3 == null && (v3 = this.defaultValue(k)) != null && (v2 = this.target.putIfAbsent(new WeakKey<K>(k, this), v3)) != null) {
            v3 = v2;
        }
        return v3;
    }

    public boolean containsKey(K k) {
        if (k == null) {
            throw new NullPointerException();
        }
        return this.target.containsKey(new LatentKey<K>(k));
    }

    public V put(K k, V v2) {
        if (k == null || v2 == null) {
            throw new NullPointerException();
        }
        return this.target.put(new WeakKey<K>(k, this), v2);
    }

    public V remove(K k) {
        if (k == null) {
            throw new NullPointerException();
        }
        return this.target.remove(new LatentKey<K>(k));
    }

    public void clear() {
        this.target.clear();
    }

    protected V defaultValue(K k) {
        return null;
    }

    public Thread getCleanerThread() {
        return this.thread;
    }

    public void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.target.remove(reference);
        }
    }

    public int approximateSize() {
        return this.target.size();
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.target.remove(this.remove());
            }
        }
        catch (InterruptedException interruptedException) {
            this.clear();
            return;
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new EntryIterator(this.target.entrySet().iterator());
    }

    private class SimpleEntry
    implements Map.Entry<K, V> {
        private final K key;
        final Map.Entry<IWeakKey<K>, V> entry;

        private SimpleEntry(K k, Map.Entry<IWeakKey<K>, V> entry) {
            this.key = k;
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V v2) {
            if (v2 == null) {
                throw new NullPointerException();
            }
            return this.entry.setValue(v2);
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<IWeakKey<K>, V>> iterator;
        private Map.Entry<IWeakKey<K>, V> nextEntry;
        private K nextKey;

        private EntryIterator(Iterator<Map.Entry<IWeakKey<K>, V>> iterator) {
            this.iterator = iterator;
            this.findNext();
        }

        private void findNext() {
            while (this.iterator.hasNext()) {
                this.nextEntry = this.iterator.next();
                this.nextKey = this.nextEntry.getKey().get();
                if (this.nextKey == null) continue;
                return;
            }
            this.nextEntry = null;
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            try {
                SimpleEntry simpleEntry = new SimpleEntry(this.nextKey, this.nextEntry);
                return simpleEntry;
            }
            finally {
                this.findNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class WithInlinedExpunction<K, V>
    extends WeakConcurrentMap<K, V> {
        public WithInlinedExpunction() {
            super(false);
        }

        @Override
        public V get(K k) {
            this.expungeStaleEntries();
            return super.get(k);
        }

        @Override
        public boolean containsKey(K k) {
            this.expungeStaleEntries();
            return super.containsKey(k);
        }

        @Override
        public V put(K k, V v2) {
            this.expungeStaleEntries();
            return super.put(k, v2);
        }

        @Override
        public V remove(K k) {
            this.expungeStaleEntries();
            return super.remove(k);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            this.expungeStaleEntries();
            return super.iterator();
        }

        @Override
        public int approximateSize() {
            this.expungeStaleEntries();
            return super.approximateSize();
        }
    }

    private static class LatentKey<T>
    implements IWeakKey<T> {
        final T key;
        private final int hashCode;

        LatentKey(T t) {
            this.key = t;
            this.hashCode = System.identityHashCode(t);
        }

        public boolean equals(Object object) {
            if (object instanceof LatentKey) {
                return ((LatentKey)object).key == this.key;
            }
            return ((WeakKey)object).get() == this.key;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public T get() {
            return this.key;
        }
    }

    private static class WeakKey<T>
    extends WeakReference<T>
    implements IWeakKey<T> {
        private final int hashCode;

        WeakKey(T t, ReferenceQueue<? super T> referenceQueue) {
            super(t, referenceQueue);
            this.hashCode = System.identityHashCode(t);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof LatentKey) {
                return ((LatentKey)object).key == this.get();
            }
            return ((WeakKey)object).get() == this.get();
        }
    }

    private static interface IWeakKey<T> {
        public T get();
    }
}

