/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.OperationTimedOutException;
import com.pnfsoftware.jeb.util.format.Strings;

public class Watchdog {
    private static final Watchdog DEFAULT = new Watchdog();
    private long t0;
    private long maxExecTime;

    public Watchdog(long l2, long l3) {
        this.t0 = l2;
        this.maxExecTime = l3;
    }

    public Watchdog(long l2) {
        this(System.currentTimeMillis(), l2);
    }

    public Watchdog() {
        this(0L);
    }

    public long getInitTime() {
        return this.t0;
    }

    public long getMaxExecTime() {
        return this.maxExecTime;
    }

    public void verify() {
        if (Thread.interrupted()) {
            throw new OperationTimedOutException("External interruption");
        }
        if (this.maxExecTime > 0L && System.currentTimeMillis() - this.t0 > this.maxExecTime) {
            String string = Strings.ff("Self interruption (operation timed-out, maximum duration allowed was %d ms)", this.maxExecTime);
            throw new OperationTimedOutException(string);
        }
    }

    public static void verify(Watchdog watchdog) {
        if (watchdog == null) {
            watchdog = DEFAULT;
        }
        watchdog.verify();
    }

    public static void verifyInterruptions() {
        Watchdog.verify(null);
    }

    public static void reportInterruption(InterruptedException interruptedException) {
        throw new OperationTimedOutException(interruptedException);
    }
}

