/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.OperationTimedOutException;
import com.pnfsoftware.jeb.util.format.Strings;

public class TimedOperationVerifier {
    public static final TimedOperationVerifier DEFAULT = new TimedOperationVerifier();
    private long t0;
    private long maxExecTime;

    public TimedOperationVerifier(long l2, long l3) {
        this.t0 = l2;
        this.maxExecTime = l3;
    }

    public TimedOperationVerifier(long l2) {
        this(System.currentTimeMillis(), l2);
    }

    public TimedOperationVerifier() {
        this(0L);
    }

    public long getInitTime() {
        return this.t0;
    }

    public long getMaxExecTime() {
        return this.maxExecTime;
    }

    public void verify() {
        long l2;
        if (Thread.interrupted()) {
            throw new OperationTimedOutException("External interruption");
        }
        if (this.maxExecTime > 0L && (l2 = System.currentTimeMillis() - this.t0) > this.maxExecTime) {
            throw new OperationTimedOutException(Strings.ff("Self interruption: exectime= %d ms; max= %d ms", l2, this.maxExecTime));
        }
    }

    public static void verify(TimedOperationVerifier timedOperationVerifier) {
        if (timedOperationVerifier == null) {
            timedOperationVerifier = DEFAULT;
        }
        timedOperationVerifier.verify();
    }

    public static void verifyInterruptions() {
        TimedOperationVerifier.verify(null);
    }

    public static void reportInterruption(InterruptedException interruptedException) {
        throw new OperationTimedOutException(interruptedException);
    }
}

