/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.IMonitorInfoProvider;

public class ThreadUtil {
    public static Thread create(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    }

    public static Thread start(Runnable runnable) {
        return ThreadUtil.start(null, runnable);
    }

    public static Thread start(String string, Runnable runnable) {
        Thread thread = ThreadUtil.create(runnable);
        if (string != null) {
            thread.setName(string);
        }
        thread.start();
        return thread;
    }

    public static boolean stop(Thread thread) {
        if (thread == null) {
            return false;
        }
        if (!thread.isAlive()) {
            return true;
        }
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
        return !thread.isAlive();
    }

    public static boolean monitor(Thread thread, IMonitorInfoProvider iMonitorInfoProvider) {
        block7: {
            long l2;
            long l3;
            long l4 = System.currentTimeMillis();
            do {
                try {
                    l3 = iMonitorInfoProvider.getProbingPeriod();
                    if (l3 <= 0L) {
                        l3 = 100L;
                    }
                    thread.join(l3);
                }
                catch (InterruptedException interruptedException) {
                    break block7;
                }
                if (!thread.isAlive()) break block7;
            } while ((l3 = iMonitorInfoProvider.getTimeout()) <= 0L || (l2 = System.currentTimeMillis() - l4) < l3);
            iMonitorInfoProvider.onInterrupt();
            if (thread.isAlive()) {
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return !thread.isAlive();
    }

    public static void joinU(Thread thread) {
        boolean bl = false;
        while (true) {
            try {
                thread.join();
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
            break;
        }
    }

    public static void interruptAndJoinUninterruptibly(Thread thread) {
        thread.interrupt();
        ThreadUtil.joinU(thread);
    }

    public static String formatStackTrace() {
        return ThreadUtil.formatStackTrace(0);
    }

    public static String formatStackTrace(int n2) {
        return ThreadUtil.formatStackTrace(n2, null, false, false);
    }

    public static String formatStackTrace(int n2, String string, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n3 = 2 + n2;
        if (string == null) {
            string = " < ";
        }
        int n4 = 0;
        for (int i = n3; i < stackTraceElementArray.length; ++i) {
            int n5;
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (n4 > 0) {
                stringBuilder.append(string);
            }
            String string2 = stackTraceElement.getClassName();
            if (!bl && (n5 = string2.lastIndexOf(46)) >= 0) {
                string2 = string2.substring(n5 + 1);
            }
            stringBuilder.append(string2).append('.').append(stackTraceElement.getMethodName());
            if (bl2) {
                stringBuilder.append(':').append(stackTraceElement.getLineNumber());
            }
            ++n4;
        }
        return stringBuilder.toString();
    }
}

