/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.IMonitorInfoProvider;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class ThreadMonitor {
    private static final ILogger logger = GlobalLog.getLogger(ThreadMonitor.class);
    private Thread thread;
    private boolean started;
    private IMonitorInfoProvider moninfo;
    private Runnable before;
    private Runnable after;
    private State state;
    private boolean success;

    public ThreadMonitor(Thread thread, boolean bl, IMonitorInfoProvider iMonitorInfoProvider, Runnable runnable, Runnable runnable2) {
        if (thread == null) {
            throw new RuntimeException();
        }
        this.thread = thread;
        this.started = bl;
        this.moninfo = iMonitorInfoProvider;
        this.before = runnable;
        this.after = runnable2;
        this.state = State.READY;
    }

    public Thread getMonitoredThread() {
        return this.thread;
    }

    public synchronized State getState() {
        return this.state;
    }

    private synchronized void setState(State state) {
        this.state = state;
    }

    public synchronized boolean isReady() {
        return this.state == State.READY;
    }

    public synchronized boolean isMonitoring() {
        return this.state == State.MONITORING;
    }

    public synchronized boolean isTerminated() {
        return this.state == State.DONE || this.state == State.ERROR;
    }

    public synchronized Thread start(final boolean bl) {
        if (this.state != State.READY) {
            throw new RuntimeException();
        }
        this.setState(State.MONITORING);
        Thread thread = ThreadUtil.start(new Runnable(){

            @Override
            public void run() {
                if (ThreadMonitor.this.before != null) {
                    ThreadMonitor.this.before.run();
                }
                if (!ThreadMonitor.this.started) {
                    ThreadMonitor.this.thread.start();
                }
                Object[] cfr_ignored_0 = new Object[0];
                ThreadMonitor.this.success = ThreadUtil.monitor(ThreadMonitor.this.thread, ThreadMonitor.this.moninfo);
                (new Object[1])[0] = ThreadMonitor.this.success;
                if (ThreadMonitor.this.after != null) {
                    ThreadMonitor.this.after.run();
                }
                if (!bl) {
                    ThreadMonitor.this.setState(ThreadMonitor.this.success ? State.DONE : State.ERROR);
                }
            }
        });
        if (bl) {
            try {
                thread.join();
                this.setState(this.success ? State.DONE : State.ERROR);
            }
            catch (InterruptedException interruptedException) {
                this.setState(State.ERROR);
            }
        }
        return thread;
    }

    public static enum State {
        READY,
        MONITORING,
        DONE,
        ERROR;

    }
}

