/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public final class ThreadEx<V>
extends Thread {
    private Runnable runnable;
    private Callable<V> callable;
    private Exception ex;
    private V result;

    public ThreadEx(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Provide a non-null Runnable object");
        }
        this.runnable = runnable;
    }

    public ThreadEx(Callable<V> callable) {
        if (callable == null) {
            throw new IllegalArgumentException("Provide a non-null Callable object");
        }
        this.callable = callable;
    }

    @Override
    public final void run() {
        try {
            if (this.runnable != null) {
                this.runnable.run();
            } else {
                this.result = this.callable.call();
            }
        }
        catch (Exception exception) {
            this.ex = exception;
        }
    }

    public V get() throws ExecutionException, InterruptedException {
        try {
            return this.get(0L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException("Should not happen", timeoutException);
        }
    }

    public V get(long l2) throws ExecutionException, InterruptedException, TimeoutException {
        this.join(l2);
        if (this.ex != null) {
            throw new ExecutionException(this.ex);
        }
        if (l2 != 0L && this.isAlive()) {
            throw new TimeoutException();
        }
        return this.result;
    }
}

