/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CommandRoutine
implements Runnable {
    public static final ILogger logger = GlobalLog.getLogger(CommandRoutine.class);
    private String[] cmdarray;
    private boolean success;
    private Object lock = new Object();
    private ByteArrayOutputStream resultBytes;
    private Process process;

    public CommandRoutine(String ... stringArray) {
        this.cmdarray = stringArray;
    }

    @Override
    public void run() {
        this.execute(this.cmdarray);
    }

    public boolean getExecutionResult() {
        return this.success;
    }

    public byte[] getExecutionOutput() {
        Object object = this.lock;
        synchronized (object) {
            if (this.resultBytes == null) {
                return null;
            }
            return this.resultBytes.toByteArray();
        }
    }

    public void killProcess() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private boolean execute(String ... stringArray) {
        this.success = this.executeSync(stringArray);
        return this.success;
    }

    private boolean executeSync(String ... stringArray) {
        Object object;
        try {
            object = new ProcessBuilder(stringArray);
            ((ProcessBuilder)object).redirectErrorStream(true);
            this.process = ((ProcessBuilder)object).start();
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
        object = this.lock;
        synchronized (object) {
            this.resultBytes = new ByteArrayOutputStream();
        }
        return this.manageStreams(this.process, this.resultBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean manageStreams(Process process, ByteArrayOutputStream byteArrayOutputStream) {
        Closeable closeable;
        try {
            closeable = process.getOutputStream();
            if (closeable != null) {
                ((OutputStream)closeable).close();
            }
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
        try {
            closeable = process.getInputStream();
            try {
                boolean bl;
                byte[] byArray = new byte[16384];
                do {
                    int n2;
                    if ((n2 = ((InputStream)closeable).available()) == 0) {
                        bl = Thread.interrupted();
                        if (!bl) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                bl = true;
                            }
                        }
                        if (bl) {
                            process.destroy();
                            boolean bl2 = false;
                            return bl2;
                        }
                    }
                    n2 = ((InputStream)closeable).read(byArray, 0, byArray.length);
                    bl = Thread.interrupted();
                    if (n2 == -1) {
                        boolean bl3 = !bl;
                        return bl3;
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        byteArrayOutputStream.write(byArray, 0, n2);
                        byteArrayOutputStream.flush();
                    }
                } while (!bl);
                boolean bl4 = false;
                return bl4;
            }
            finally {
                if (closeable != null) {
                    ((InputStream)closeable).close();
                }
            }
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
    }
}

