/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.CommandRoutine;
import com.pnfsoftware.jeb.util.concurrent.MonitorInfoAdapter;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import java.util.Collection;

public class CommandExec {
    private long timeout;
    private byte[] output;

    public CommandExec(long l2) {
        this.timeout = l2;
    }

    public byte[] getOutput() {
        return this.output;
    }

    public boolean execute(Collection<String> collection) {
        String[] stringArray = collection.toArray(new String[collection.size()]);
        return this.execute(stringArray);
    }

    public boolean execute(String ... stringArray) {
        this.output = null;
        final CommandRoutine commandRoutine = new CommandRoutine(stringArray);
        if (this.timeout == 0L) {
            commandRoutine.run();
        } else if (this.timeout > 0L) {
            Thread thread = ThreadUtil.start(commandRoutine);
            ThreadUtil.monitor(thread, new MonitorInfoAdapter(this.timeout, 100L){

                @Override
                public void onInterrupt() {
                    commandRoutine.killProcess();
                }
            });
        } else {
            Thread thread = ThreadUtil.start(commandRoutine);
            try {
                thread.join(-this.timeout);
            }
            catch (InterruptedException interruptedException) {}
            this.output = commandRoutine.getExecutionOutput();
            return true;
        }
        this.output = commandRoutine.getExecutionOutput();
        return commandRoutine.getExecutionResult();
    }
}

