/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;

@Ser
public abstract class ActiveTask
implements Runnable {
    private static final ILogger logger = GlobalLog.getLogger(ActiveTask.class);
    @SerTransient
    private volatile Thread thread;
    @SerTransient
    private volatile Runnable completion;
    @SerTransient
    private volatile boolean cancelRequested;
    @SerTransient
    private volatile String name;

    public ActiveTask(String string) {
        this.name = string;
    }

    public ActiveTask() {
    }

    public synchronized boolean start(Runnable runnable) {
        if (this.thread == null || !this.thread.isAlive()) {
            this.completion = runnable;
            this.thread = ThreadUtil.start(this.name, this);
            return true;
        }
        return false;
    }

    public synchronized boolean interrupt() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            return true;
        }
        return false;
    }

    public synchronized boolean cancel() {
        return this.cancel(true);
    }

    public synchronized boolean cancel(boolean bl) {
        this.cancelRequested = true;
        if (this.thread != null && this.thread.isAlive()) {
            if (bl) {
                this.thread.interrupt();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isDone() {
        return this.thread == null || !this.thread.isAlive();
    }

    public final boolean isCancelled() {
        return this.cancelRequested;
    }

    public synchronized boolean join() throws InterruptedException {
        return this.join(0L);
    }

    public synchronized boolean join(long l2) throws InterruptedException {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.join(l2);
        }
        return true;
    }

    @Override
    public void run() {
        try {
            this.onPreExecution();
            this.runi();
            this.onPostExecution();
        }
        catch (Exception exception) {
            if (this.thread == null) {
                throw exception;
            }
            this.onException(exception);
        }
        finally {
            if (this.completion != null) {
                try {
                    this.completion.run();
                }
                finally {
                    this.completion = null;
                }
            }
        }
    }

    public abstract void runi();

    protected void onPreExecution() {
    }

    protected void onPostExecution() {
    }

    protected void onException(Exception exception) {
        logger.catching(exception);
    }
}

