/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;

@Ser
public class WeakValueMap<K, V>
implements Map<K, V> {
    @SerTransient
    private Map<K, WeakValueRef<K, V>> map;
    @SerTransient
    private ReferenceQueue<V> queue;
    @SerId(value=1)
    private int initialCapacity;
    @SerId(value=2)
    private float loadFactor;
    @SerId(value=3)
    private List<Couple<K, V>> rlistForStorage;

    @SerCustomWrite
    private void save(SerializerHelper serializerHelper) throws IOException {
        this.rlistForStorage = this.toList();
        serializerHelper.saveStandard();
        this.rlistForStorage = null;
    }

    @SerCustomInitPostGraph
    private void postInit() {
        for (Couple<K, V> couple : this.rlistForStorage) {
            this.put(couple.getFirst(), couple.getSecond());
        }
        this.rlistForStorage = null;
    }

    @SerCustomInit
    private void init() {
        this.queue = new ReferenceQueue();
        this.map = new HashMap<K, WeakValueRef<K, V>>(this.initialCapacity, this.loadFactor);
    }

    public WeakValueMap(int n2, float f) {
        this.initialCapacity = n2;
        this.loadFactor = f;
        this.init();
    }

    public WeakValueMap(int n2) {
        this(n2, 0.75f);
    }

    public WeakValueMap() {
        this(16);
    }

    public WeakValueMap(Map<K, V> map) {
        this(Math.max(2 * map.size(), 11));
        this.putAll(map);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        this.processQueue();
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        this.processQueue();
        for (Map.Entry<K, WeakValueRef<K, V>> entry : this.map.entrySet()) {
            if (entry.getValue() == null) continue;
            Object t = entry.getValue().get();
            if (!(object == null ? t == null : object.equals(t))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, WeakValueRef<K, V>> entry : this.map.entrySet()) {
            if (entry.getValue() == null) continue;
            hashSet.add((Map.Entry<K, V>)new DefaultMapEntry(entry.getKey(), entry.getValue().get()));
        }
        return hashSet;
    }

    List<Couple<K, V>> toList() {
        this.processQueue();
        ArrayList<Couple<K, V>> arrayList = new ArrayList<Couple<K, V>>();
        for (Map.Entry<K, WeakValueRef<K, V>> entry : this.map.entrySet()) {
            if (entry.getValue() == null) continue;
            arrayList.add(new Couple(entry.getKey(), entry.getValue().get()));
        }
        return arrayList;
    }

    @Override
    public V get(Object object) {
        this.processQueue();
        WeakReference weakReference = this.map.get(object);
        if (weakReference == null) {
            return null;
        }
        return (V)weakReference.get();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.map.keySet();
    }

    @Override
    public V put(K k, V v2) {
        this.processQueue();
        WeakReference weakReference = this.map.put(k, WeakValueRef.create(k, v2, this.queue));
        if (weakReference == null) {
            return null;
        }
        return (V)weakReference.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.processQueue();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        this.processQueue();
        WeakReference weakReference = this.map.remove(object);
        if (weakReference == null) {
            return null;
        }
        return (V)weakReference.get();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        ArrayList arrayList = new ArrayList();
        for (WeakReference weakReference : this.map.values()) {
            if (weakReference == null) continue;
            arrayList.add(weakReference.get());
        }
        return arrayList;
    }

    private void processQueue() {
        WeakValueRef weakValueRef;
        while ((weakValueRef = (WeakValueRef)this.queue.poll()) != null) {
            if (weakValueRef != this.map.get(weakValueRef.key)) continue;
            this.map.remove(weakValueRef.key);
        }
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    public String toString() {
        return this.map.toString();
    }

    @SerDisabled
    private static class WeakValueRef<K, V>
    extends WeakReference<V> {
        public K key;

        private WeakValueRef(K k, V v2, ReferenceQueue<V> referenceQueue) {
            super(v2, referenceQueue);
            this.key = k;
        }

        private static <K, V> WeakValueRef<K, V> create(K k, V v2, ReferenceQueue<V> referenceQueue) {
            if (v2 == null) {
                return null;
            }
            return new WeakValueRef<K, V>(k, v2, referenceQueue);
        }

        public int hashCode() {
            Object t = this.get();
            return t == null ? 0 : t.hashCode();
        }

        public boolean equals(Object object) {
            Object t = this.get();
            return t == null ? object == null : t.equals(object);
        }

        public String toString() {
            Object t = this.get();
            return t == null ? null : t.toString();
        }
    }
}

