/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomRead;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jeb.util.serialization.annotations.SerVersion;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;

@Ser
@SerVersion(value=2)
public class WeakIdentityHashMap<K, V> {
    @SerTransient
    private HashMap<IdentityWeakKeyRef<K>, V> map;
    @SerTransient
    private ReferenceQueue<K> queue;
    @SerId(value=1)
    private int initialCapacity;
    @SerId(value=2)
    private float loadFactor;
    @SerId(value=3)
    private List<Couple<K, V>> rlistForStorage;

    @SerCustomWrite
    private void save(SerializerHelper serializerHelper) throws IOException {
        this.expunge();
        this.rlistForStorage = this.toList();
        serializerHelper.saveStandard();
        this.rlistForStorage = null;
    }

    @SerCustomRead
    private void load(DeserializerHelper deserializerHelper) throws IOException {
        if (deserializerHelper.getSerializedVersion() == 0) {
            ArrayList arrayList = (ArrayList)deserializerHelper.read();
            ArrayList arrayList2 = (ArrayList)deserializerHelper.read();
            this.rlistForStorage = new ArrayList<Couple<K, V>>(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                this.rlistForStorage.add(new Couple(arrayList.get(i), arrayList2.get(i)));
            }
            this.initialCapacity = 16;
            this.loadFactor = 0.75f;
        } else if (deserializerHelper.getSerializedVersion() == 1) {
            deserializerHelper.loadStandard();
            this.rlistForStorage = (List)deserializerHelper.read();
        } else {
            deserializerHelper.loadStandard();
        }
    }

    @SerCustomInitPostGraph
    private void postInit() {
        for (Couple<K, V> couple : this.rlistForStorage) {
            this.put(couple.getFirst(), couple.getSecond());
        }
        this.rlistForStorage = null;
    }

    @SerCustomInit
    private void init() {
        this.queue = new ReferenceQueue();
        this.map = new HashMap(this.initialCapacity, this.loadFactor);
    }

    List<Couple<K, V>> toList() {
        this.expunge();
        ArrayList<Couple<K, V>> arrayList = new ArrayList<Couple<K, V>>();
        for (Map.Entry<IdentityWeakKeyRef<K>, V> entry : this.map.entrySet()) {
            if (entry.getKey() == null) continue;
            arrayList.add(new Couple(entry.getKey().get(), entry.getValue()));
        }
        return arrayList;
    }

    public WeakIdentityHashMap(int n2, float f) {
        this.initialCapacity = n2;
        this.loadFactor = f;
        this.init();
    }

    public WeakIdentityHashMap(int n2) {
        this(n2, 0.75f);
    }

    public WeakIdentityHashMap() {
        this(16);
    }

    public V get(K k) {
        this.expunge();
        return this.map.get(this.makeReference(k));
    }

    public Set<K> keySet() {
        this.expunge();
        HashSet hashSet = new HashSet();
        for (IdentityWeakKeyRef<K> identityWeakKeyRef : this.map.keySet()) {
            Object t = identityWeakKeyRef.get();
            if (t == null) continue;
            hashSet.add(t);
        }
        return hashSet;
    }

    public int size() {
        this.expunge();
        int n2 = 0;
        for (IdentityWeakKeyRef<K> identityWeakKeyRef : this.map.keySet()) {
            Object t = identityWeakKeyRef.get();
            if (t == null) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Collection<V> values() {
        this.expunge();
        return this.map.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.expunge();
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
        for (IdentityWeakKeyRef<K> identityWeakKeyRef : this.map.keySet()) {
            Object t = identityWeakKeyRef.get();
            if (t == null) continue;
            hashSet.add((Map.Entry<K, V>)new DefaultMapEntry(t, this.map.get(identityWeakKeyRef)));
        }
        return hashSet;
    }

    public V put(K k, V v2) {
        this.expunge();
        if (k == null) {
            throw new IllegalArgumentException("Null key");
        }
        return this.putUnsafe(k, v2);
    }

    public V putUnsafe(K k, V v2) {
        return this.map.put(this.makeReference(k, this.queue), v2);
    }

    public V remove(K k) {
        this.expunge();
        return this.map.remove(this.makeReference(k));
    }

    public void clear() {
        this.expunge();
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    private void expunge() {
        Reference<K> reference;
        while ((reference = this.queue.poll()) != null) {
            this.map.remove(reference);
        }
    }

    private IdentityWeakKeyRef<K> makeReference(K k) {
        return new IdentityWeakKeyRef<K>(k);
    }

    private IdentityWeakKeyRef<K> makeReference(K k, ReferenceQueue<K> referenceQueue) {
        return new IdentityWeakKeyRef<K>(k, referenceQueue);
    }

    @SerDisabled
    private static class IdentityWeakKeyRef<K>
    extends WeakReference<K> {
        private final int hashCode;

        IdentityWeakKeyRef(K k) {
            this(k, (ReferenceQueue<K>)null);
        }

        IdentityWeakKeyRef(K k, ReferenceQueue<K> referenceQueue) {
            super(k, referenceQueue);
            this.hashCode = k == null ? 0 : System.identityHashCode(k);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IdentityWeakKeyRef)) {
                return false;
            }
            IdentityWeakKeyRef identityWeakKeyRef = (IdentityWeakKeyRef)object;
            Object t = this.get();
            return t != null && t == identityWeakKeyRef.get();
        }

        public String toString() {
            Object t = this.get();
            return t == null ? null : t.toString();
        }
    }
}

