/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

@Ser
public class SynchronizedLinkedSet<E> {
    @SerId(value=1)
    private LinkedHashSet<E> set0 = new LinkedHashSet();
    @SerTransient
    private Set<E> set;

    @SerCustomInitPostGraph
    private void init() {
        this.set = Collections.synchronizedSet(this.set0);
    }

    public SynchronizedLinkedSet() {
        this.init();
    }

    public int size() {
        return this.set.size();
    }

    public void clear() {
        this.set.clear();
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public boolean contains(E e) {
        return this.set.contains(e);
    }

    public boolean add(E e) {
        if (e == null) {
            throw new NullPointerException("Illegal null key");
        }
        return this.set.add(e);
    }

    public boolean remove(E e) {
        return this.set.remove(e);
    }

    public Set<E> copyOfEntries() {
        Set<E> set = this.set;
        synchronized (set) {
            return new LinkedHashSet<E>(this.set);
        }
    }

    public E firstEntry() {
        Set<E> set = this.set;
        synchronized (set) {
            return this.set.iterator().next();
        }
    }

    public String toString() {
        return this.set.toString();
    }
}

