/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Ser
public class SynchronizedLinkedMap<K, V> {
    @SerId(value=1)
    private LinkedHashMap<K, V> map0 = new LinkedHashMap();
    @SerTransient
    private Map<K, V> map;

    @SerCustomInitPostGraph
    private void init() {
        this.map = Collections.synchronizedMap(this.map0);
    }

    public SynchronizedLinkedMap() {
        this.init();
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(V v2) {
        return this.map.containsValue(v2);
    }

    public V get(K k) {
        return this.map.get(k);
    }

    public V put(K k, V v2) {
        if (k == null) {
            throw new NullPointerException("Illegal null key");
        }
        if (v2 == null) {
            throw new NullPointerException("Illegal null value");
        }
        return this.map.put(k, v2);
    }

    public V remove(K k) {
        return this.map.remove(k);
    }

    public Set<K> copyOfKeys() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return new LinkedHashSet<K>(this.map.keySet());
        }
    }

    public List<V> copyOfValues() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return new ArrayList<V>(this.map.values());
        }
    }

    public K firstKey() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.keySet().iterator().next();
        }
    }

    public String toString() {
        return this.map.toString();
    }
}

