/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.CollectionOrder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

@Ser
public class SetMap<K, V> {
    @SerId(value=1)
    private Map<K, Set<V>> map;
    @SerId(value=2)
    private CollectionOrder setOrder;
    @SerId(value=3)
    private int cachedSize;

    public SetMap() {
        this(CollectionOrder.NONE, CollectionOrder.NONE);
    }

    public SetMap(CollectionOrder collectionOrder, CollectionOrder collectionOrder2) {
        if (collectionOrder == null) {
            throw new NullPointerException("Illegal key order");
        }
        switch (collectionOrder) {
            case NONE: {
                this.map = new HashMap<K, Set<V>>();
                break;
            }
            case INSERTION: {
                this.map = new LinkedHashMap<K, Set<V>>();
                break;
            }
            case NATURAL: {
                this.map = new TreeMap<K, Set<V>>();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (collectionOrder2 == null) {
            throw new NullPointerException("Illegal collection type");
        }
        this.setOrder = collectionOrder2;
        this.cachedSize = 0;
    }

    public void clear() {
        this.map.clear();
        this.cachedSize = 0;
    }

    public int keySize() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.cachedSize == 0;
    }

    public int size() {
        return this.cachedSize;
    }

    public int put(K k, V v2) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            set = this.newColl();
            this.map.put(k, set);
        }
        if (set.add(v2)) {
            ++this.cachedSize;
        }
        return set.size();
    }

    public void putMulti(K k, Collection<? extends V> collection) {
        for (V v2 : collection) {
            this.put(k, v2);
        }
    }

    public void putAll(Map<? extends K, List<? extends V>> map) {
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            for (V v2 : entry.getValue()) {
                this.put(entry.getKey(), v2);
            }
        }
    }

    public boolean createKey(K k) {
        Set<V> set = this.map.get(k);
        if (set != null) {
            return false;
        }
        this.map.put(k, this.newColl());
        return true;
    }

    private Set<V> newColl() {
        switch (this.setOrder) {
            case NONE: {
                return new HashSet();
            }
            case INSERTION: {
                return new LinkedHashSet();
            }
            case NATURAL: {
                return new TreeSet();
            }
        }
        throw new RuntimeException();
    }

    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(V v2) {
        for (Set<V> set : this.map.values()) {
            if (!set.contains(v2)) continue;
            return true;
        }
        return false;
    }

    public Set<V> get(K k) {
        return this.get(k, false);
    }

    public Set<V> get(K k, boolean bl) {
        Set<V> set = this.map.get(k);
        if (set != null) {
            return set;
        }
        if (bl) {
            return Collections.emptySet();
        }
        return null;
    }

    public Set<V> getSafe(K k) {
        return this.get(k, true);
    }

    public Set<V> remove(K k) {
        Set<V> set = this.map.remove(k);
        if (set != null) {
            this.cachedSize -= set.size();
        }
        return set;
    }

    public V removeValue(K k, V v2) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            return null;
        }
        if (!set.remove(v2)) {
            return null;
        }
        --this.cachedSize;
        return v2;
    }

    public int removeMulti(K k, Collection<? extends V> collection) {
        Set<V> set = this.map.get(k);
        if (collection == null) {
            return 0;
        }
        int n2 = 0;
        for (V v2 : collection) {
            if (!set.remove(v2)) continue;
            --this.cachedSize;
            ++n2;
        }
        return n2;
    }

    public Set<V> values() {
        Set<V> set = this.newColl();
        for (Set<V> set2 : this.map.values()) {
            set.addAll(set2);
        }
        return Collections.unmodifiableSet(set);
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public boolean removeAll(Collection<K> collection) {
        if (this.isEmpty()) {
            return false;
        }
        for (K k : collection) {
            this.remove(k);
        }
        return true;
    }

    public String toString() {
        return this.map.toString();
    }
}

