/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.ISegment;
import com.pnfsoftware.jeb.util.collect.ISegmentFactory;
import com.pnfsoftware.jeb.util.collect.ISegmentGapVerifier;
import com.pnfsoftware.jeb.util.collect.ISegmentMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiFunction;

@Ser
public class SegmentMap<K extends Comparable<K>, V extends ISegment<K>>
extends ConcurrentSkipListMap<K, V>
implements ISegmentMap<K, V> {
    private static final long serialVersionUID = 1L;
    @SerId(value=1)
    boolean removeSegmentsOnOverlap;

    @SerConstructor
    public SegmentMap() {
    }

    public SegmentMap(SegmentMap<K, V> segmentMap) {
        super(segmentMap);
        this.removeSegmentsOnOverlap = segmentMap.removeSegmentsOnOverlap;
    }

    protected SegmentMap(Comparator<? super K> comparator) {
        super(comparator);
    }

    public void setRemoveSegmentsOnOverlap(boolean bl) {
        this.removeSegmentsOnOverlap = bl;
    }

    public boolean isRemoveSegmentsOnOverlap() {
        return this.removeSegmentsOnOverlap;
    }

    @Override
    public V add(V v2) {
        this.put((K)v2.getBegin(), v2);
        return v2;
    }

    @Override
    public V addAndMerge(V v2, BiFunction<Couple<K, K>, List<V>, V> biFunction) {
        HashSet hashSet = new HashSet(this.getOverlappingSegmentsMap(v2.getBegin(), true, v2.getEnd(), true).keySet());
        if (hashSet.isEmpty()) {
            return this.add(v2);
        }
        Object object = v2.getBegin();
        Object k = v2.getEnd();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(v2);
        for (Object object2 : hashSet) {
            object = object2.compareTo(object) < 0 ? object2 : object;
            Object object3 = ((ISegment)this.get(object2)).getEnd();
            k = object3.compareTo(k) > 0 ? object3 : k;
            arrayList.add((ISegment)this.get(object2));
        }
        ISegment iSegment = (ISegment)biFunction.apply(new Couple(object, k), arrayList);
        if (iSegment == null) {
            return null;
        }
        for (Object object3 : hashSet) {
            this.remove(object3);
        }
        return (V)this.add(iSegment);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put((K)((Comparable)entry.getKey()), (V)((ISegment)entry.getValue()));
        }
    }

    public int compareKeys(K k, K k2) {
        Comparator comparator = this.comparator();
        return comparator != null ? comparator.compare(k, k2) : k.compareTo(k2);
    }

    @Override
    public V put(K k, V v2) {
        if (!k.equals(v2.getBegin())) {
            throw new IllegalArgumentException(String.format("The provided key differs from the segment's begin value: %s != %s", k, v2.getBegin()));
        }
        if (!this.isValidKey(k)) {
            throw new IllegalArgumentException("Invalid key: " + k);
        }
        if (!this.isValidKey(v2.getEnd())) {
            throw new IllegalArgumentException("Invalid end key: " + v2.getEnd());
        }
        if (!this.isValidSegment(v2)) {
            throw new IllegalArgumentException("Invalid segment: " + v2);
        }
        Map.Entry entry = this.lowerEntry(v2.getEnd());
        if (entry != null && this.compareKeys(((ISegment)entry.getValue()).getEnd(), k) > 0) {
            if (!this.removeSegmentsOnOverlap) {
                throw new IllegalArgumentException("Attempt to insert the given segment overlaps existing segment(s)");
            }
            HashSet<K> hashSet = new HashSet<K>(this.getOverlappingSegmentsMap(k, true, v2.getEnd(), true).keySet());
            for (Comparable comparable : hashSet) {
                this.remove(comparable);
            }
        }
        return (V)((ISegment)super.put(k, v2));
    }

    public boolean isValidKey(K k) {
        return true;
    }

    public boolean isValidSegment(V v2) {
        return this.compareKeys(v2.getBegin(), v2.getEnd()) < 0;
    }

    @Override
    public V getSegmentContaining(K k) {
        Map.Entry entry = this.floorEntry(k);
        if (entry == null) {
            return null;
        }
        ISegment iSegment = (ISegment)entry.getValue();
        if (this.compareKeys(k, iSegment.getEnd()) < 0) {
            return (V)iSegment;
        }
        return null;
    }

    @Override
    public V getSegmentAfter(K k) {
        Map.Entry entry = this.higherEntry(k);
        if (entry == null) {
            return null;
        }
        return (V)((ISegment)entry.getValue());
    }

    @Override
    public V getSegmentBefore(K k) {
        Map.Entry entry;
        V v2 = this.getSegmentContaining(k);
        if (v2 != null) {
            k = v2.getBegin();
        }
        if ((entry = this.lowerEntry(k)) == null) {
            return null;
        }
        return (V)((ISegment)entry.getValue());
    }

    @Override
    public SortedMap<K, V> getOverlappingSegmentsMap(K k, boolean bl, K k2, boolean bl2) {
        Object object;
        TreeMap treeMap = new TreeMap();
        boolean bl3 = true;
        if (bl) {
            object = this.getSegmentContaining(k);
            if (object != null) {
                treeMap.put(object.getBegin(), object);
            }
            bl3 = false;
        }
        object = this.subMap(k, bl3, k2, false);
        treeMap.putAll(object);
        Map.Entry entry = object.lastEntry();
        if (entry != null && !bl2 && this.compareKeys(((ISegment)entry.getValue()).getEnd(), k2) > 0) {
            object.remove(entry.getKey());
        }
        return treeMap;
    }

    @Override
    public boolean isEmptyRange(K k, K k2) {
        if (this.getSegmentContaining(k) != null) {
            return false;
        }
        V v2 = this.getSegmentAfter(k);
        if (v2 == null) {
            return true;
        }
        return this.compareKeys(v2.getBegin(), k2) >= 0;
    }

    @Override
    public SortedMap<K, V> contiguousSubMap(K k, K k2, ISegmentFactory<K, V> iSegmentFactory) {
        List<V> list = this.generateGapItems(k, true, k2, true, iSegmentFactory, false);
        TreeMap treeMap = new TreeMap(this.subMap((Object)k, (Object)k2));
        for (ISegment iSegment : list) {
            treeMap.put(iSegment.getBegin(), iSegment);
        }
        return treeMap;
    }

    @Override
    public List<V> fillGaps(K k, K k2, ISegmentFactory<K, V> iSegmentFactory) {
        return this.generateGapItems(k, true, k2, true, iSegmentFactory, true);
    }

    @Override
    public List<V> generateGapItems(K k, boolean bl, K k2, boolean bl2, ISegmentFactory<K, V> iSegmentFactory, boolean bl3) {
        int n2;
        ArrayList<ISegment> arrayList = new ArrayList<ISegment>();
        Object object = this.getSegmentContaining(k);
        if (object == null) {
            object = this.getSegmentAfter(k);
            if (object == null || this.compareKeys(object.getBegin(), k2) > 0) {
                if (bl && bl2) {
                    arrayList.add(this.add((ISegment)iSegmentFactory.create((Iterator<Object>)k, (Iterator<Object>)k2)));
                }
                return arrayList;
            }
            if (bl) {
                arrayList.add((ISegment)iSegmentFactory.create((Iterator<Object>)k, (Iterator<Object>)object.getBegin()));
            }
        }
        ConcurrentNavigableMap concurrentNavigableMap = this.subMap((K)object.getBegin(), false, k2, false);
        Iterator<Object> iterator = concurrentNavigableMap.keySet().iterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            ISegment iSegment = (ISegment)concurrentNavigableMap.get(comparable);
            Object k3 = object.getEnd();
            int n3 = this.compareKeys(iSegment.getBegin(), k3);
            if (n3 > 0) {
                arrayList.add((ISegment)iSegmentFactory.create((Iterator<Object>)k3, (Iterator<Object>)iSegment.getBegin()));
            }
            object = iSegment;
        }
        if (bl2 && (n2 = this.compareKeys(k2, iterator = object.getEnd())) > 0) {
            arrayList.add((ISegment)iSegmentFactory.create(iterator, (Iterator<Object>)k2));
        }
        if (bl3) {
            for (ISegment iSegment : arrayList) {
                this.put((K)iSegment.getBegin(), (V)iSegment);
            }
        }
        return arrayList;
    }

    private boolean verify(ISegmentGapVerifier<K> iSegmentGapVerifier, K k, K k2, List<Couple<K, K>> list) {
        ISegmentGapVerifier.VerificationCode verificationCode = iSegmentGapVerifier == null ? ISegmentGapVerifier.VerificationCode.INCLUDE_AND_CONTINUE : iSegmentGapVerifier.verify(k, k2);
        switch (verificationCode) {
            case INCLUDE_AND_CONTINUE: {
                list.add(new Couple<K, K>(k, k2));
                return true;
            }
            case INCLUDE_AND_EXIT: {
                list.add(new Couple<K, K>(k, k2));
                return false;
            }
            case SKIP_AND_CONTINUE: {
                return true;
            }
            case SKIP_AND_EXIT: {
                return false;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public List<Couple<K, K>> generateGaps(K k, boolean bl, K k2, boolean bl2, ISegmentGapVerifier<K> iSegmentGapVerifier) {
        int n2;
        ArrayList<Couple<K, K>> arrayList = new ArrayList<Couple<K, K>>();
        Object object = this.getSegmentContaining(k);
        if (object == null) {
            object = this.getSegmentAfter(k);
            if (object == null || this.compareKeys(object.getBegin(), k2) > 0) {
                if (bl && bl2 && !this.verify(iSegmentGapVerifier, k, k2, arrayList)) {
                    return arrayList;
                }
                return arrayList;
            }
            if (bl && !this.verify(iSegmentGapVerifier, k, object.getBegin(), arrayList)) {
                return arrayList;
            }
        }
        ConcurrentNavigableMap concurrentNavigableMap = this.subMap((K)object.getBegin(), false, k2, false);
        Iterator iterator = concurrentNavigableMap.keySet().iterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            ISegment iSegment = (ISegment)concurrentNavigableMap.get(comparable);
            Object k3 = object.getEnd();
            int n3 = this.compareKeys(iSegment.getBegin(), k3);
            if (n3 > 0 && !this.verify(iSegmentGapVerifier, k3, iSegment.getBegin(), arrayList)) {
                return arrayList;
            }
            object = iSegment;
        }
        if (bl2 && (n2 = this.compareKeys(k2, iterator = object.getEnd())) > 0 && !this.verify(iSegmentGapVerifier, iterator, k2, arrayList)) {
            return arrayList;
        }
        return arrayList;
    }

    @Override
    public List<Couple<K, K>> generateGaps(K k, boolean bl, K k2, boolean bl2) {
        return this.generateGaps(k, bl, k2, bl2, null);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        try {
            return super.subMap((Object)k, bl, (Object)k2, bl2);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            String string = Strings.ff("Bad SegmentMap subMap() query: from=%s to=%s", k, k2);
            throw new RuntimeException(string, runtimeException);
        }
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.removeSegmentsOnOverlap ? 1231 : 1237);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SegmentMap segmentMap = (SegmentMap)object;
        return this.removeSegmentsOnOverlap == segmentMap.removeSegmentsOnOverlap;
    }

    @Override
    public String toString() {
        return Strings.ff("smap:%d[%s]", this.size(), super.toString());
    }
}

