/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Ser
public class ReferenceCounter<K> {
    @SerId(value=1)
    private Map<K, Integer> map = new HashMap<K, Integer>();

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized int getCount() {
        int n2 = 0;
        for (int n3 : this.map.values()) {
            n2 += n3;
        }
        return n2;
    }

    public synchronized int inc(K k) {
        Integer n2 = this.map.get(k);
        if (n2 == null) {
            n2 = 1;
        } else if ((n2 = Integer.valueOf(n2 + 1)) < 0) {
            throw new IllegalStateException("Counter overflow");
        }
        this.map.put(k, n2);
        return n2;
    }

    public synchronized int dec(K k) {
        Integer n2 = this.map.get(k);
        if (n2 == null) {
            throw new IllegalArgumentException("Key is not present");
        }
        if (n2 <= 0) {
            throw new RuntimeException("Count is <= 0");
        }
        if ((n2 = Integer.valueOf(n2 - 1)) == 0) {
            this.map.remove(k);
        } else {
            this.map.put(k, n2);
        }
        return n2;
    }

    public synchronized boolean has(K k) {
        return this.map.containsKey(k);
    }

    public synchronized int get(K k) {
        Integer n2 = this.map.get(k);
        return n2 == null ? 0 : n2;
    }

    public synchronized Map<K, Integer> getAsMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public synchronized boolean remove(K k) {
        return this.map.remove(k) != null;
    }

    public synchronized void load(Collection<? extends K> collection) {
        for (K k : collection) {
            this.inc(k);
        }
    }

    public synchronized Set<K> keys() {
        return new HashSet<K>(this.map.keySet());
    }

    public synchronized Map<K, Integer> copyToMap() {
        return new HashMap<K, Integer>(this.map);
    }

    public synchronized String toString() {
        return this.map.toString();
    }

    public synchronized String formatAllReferences() {
        return this.formatTopReferences(-1);
    }

    public synchronized String formatTopReferences(int n2) {
        double d;
        ArrayList<Map.Entry<K, Integer>> arrayList = new ArrayList<Map.Entry<K, Integer>>(this.map.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<K, Integer>>(){

            @Override
            public int compare(Map.Entry<K, Integer> entry, Map.Entry<K, Integer> entry2) {
                return -Integer.compare(entry.getValue(), entry2.getValue());
            }
        });
        int n3 = n2 < 0 ? arrayList.size() : Math.min(n2, arrayList.size());
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : arrayList.subList(0, n3)) {
            Strings.ff(stringBuilder, "- %d: %s\n", object.getValue(), object.getKey());
            n4 += ((Integer)object.getValue()).intValue();
        }
        int n5 = n4;
        for (Map.Entry entry : arrayList.subList(n3, arrayList.size())) {
            n5 += ((Integer)entry.getValue()).intValue();
        }
        double d2 = d = n5 == 0 ? 0.0 : (double)n4 / (double)n5 * 100.0;
        if (n2 >= 0) {
            stringBuilder.insert(0, Strings.ff("%d/%d top entries (%.2f%% of %d)\n", n3, arrayList.size(), d, n5));
        }
        return stringBuilder.toString();
    }
}

