/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.IMultiSegmentMap;
import com.pnfsoftware.jeb.util.collect.ISegment;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

@Ser
public class MultiSegmentMap<K extends Comparable<K>, V extends ISegment<K>>
implements IMultiSegmentMap<K, V> {
    @SerId(value=1)
    private TreeMap<K, List<V>> map;
    @SerId(value=2)
    private int cachedSize;

    public MultiSegmentMap() {
        this.map = new TreeMap();
    }

    protected MultiSegmentMap(Comparator<? super K> comparator) {
        this.map = new TreeMap(comparator);
    }

    public int compareKeys(K k, K k2) {
        Comparator<K> comparator = this.map.comparator();
        return comparator != null ? comparator.compare(k, k2) : k.compareTo(k2);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.cachedSize = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.cachedSize == 0;
    }

    @Override
    public int size() {
        return this.cachedSize;
    }

    @Override
    public V add(V v2) {
        Object k = v2.getBegin();
        Maps.putMulti(this.map, k, v2);
        ++this.cachedSize;
        return v2;
    }

    @Override
    public V getFirstSegmentContaining(K k) {
        Comparable comparable;
        if (!this.map.isEmpty() && this.compareKeys(comparable = (Comparable)this.map.firstKey(), k) <= 0) {
            for (List<V> list : this.map.subMap(comparable, (Comparable)k).values()) {
                for (ISegment iSegment : list) {
                    if (this.compareKeys(iSegment.getEnd(), k) <= 0) continue;
                    return (V)iSegment;
                }
            }
        }
        return null;
    }

    @Override
    public List<V> getSegmentsContaining(K k) {
        Comparable comparable;
        ArrayList<ISegment> arrayList = new ArrayList<ISegment>();
        if (!this.map.isEmpty() && this.compareKeys(comparable = (Comparable)this.map.firstKey(), k) <= 0) {
            for (List<V> list : this.map.subMap(comparable, (Comparable)k).values()) {
                for (ISegment iSegment : list) {
                    if (this.compareKeys(iSegment.getEnd(), k) <= 0) continue;
                    arrayList.add(iSegment);
                }
            }
        }
        return arrayList;
    }
}

